/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridCacheKey;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public final class Axis
extends NamedElement {
    public final char abbreviation;
    final AxisDirection direction;
    final int[] sourceDimensions;
    private final int[] sourceSizes;
    final Variable coordinates;

    public Axis(char c, String string, int[] nArray, int[] nArray2, Variable variable) throws IOException, DataStoreException {
        AxisDirection axisDirection = (AxisDirection)Types.forCodeName(AxisDirection.class, (String)string, (boolean)false);
        AxisDirection axisDirection2 = AxisDirections.fromAbbreviation((char)c);
        boolean bl = axisDirection != null;
        boolean bl2 = true;
        if (axisDirection == null) {
            axisDirection = axisDirection2;
        } else if (axisDirection2 != null) {
            bl2 = AxisDirections.isColinear((AxisDirection)axisDirection, (AxisDirection)axisDirection2);
        }
        if (bl2) {
            axisDirection2 = Axis.direction(variable.getUnitsString());
            if (axisDirection == null) {
                axisDirection = axisDirection2;
            } else if (axisDirection2 != null) {
                bl2 = AxisDirections.isColinear((AxisDirection)axisDirection, (AxisDirection)axisDirection2);
            }
        }
        if (!bl2) {
            variable.warning(Grid.class, "getAxes", (short)9, variable.getFilename(), variable.getName(), axisDirection, axisDirection2);
            if (bl) {
                if (AxisDirections.isOpposite((AxisDirection)axisDirection)) {
                    axisDirection2 = AxisDirections.opposite((AxisDirection)axisDirection2);
                }
                axisDirection = axisDirection2;
            }
        }
        this.direction = axisDirection;
        this.abbreviation = c;
        this.sourceDimensions = nArray;
        this.sourceSizes = nArray2;
        this.coordinates = variable;
        if (variable.getAttributeType("_FillValue") != null) {
            int n = this.getSizeProduct(1);
            Vector vector = variable.read();
            int n2 = vector.size();
            while (--n2 >= 0 && vector.isNaN(n2)) {
            }
            int n3 = Numerics.ceilDiv(++n2, n);
            assert (n3 <= nArray2[0]) : n3;
            nArray2[0] = n3;
            assert (this.getSizeProduct(0) == n2) : n2;
        }
    }

    public static AxisDirection direction(String string) {
        if (string != null) {
            int n = string.indexOf(95);
            if (n < 0) {
                n = string.indexOf(32);
            }
            if (n > 0) {
                String string2 = string.substring(n + 1);
                if (string2.length() == 1) {
                    switch (Character.toUpperCase(string2.charAt(0))) {
                        case 'E': {
                            return AxisDirection.EAST;
                        }
                        case 'N': {
                            return AxisDirection.NORTH;
                        }
                    }
                }
                return (AxisDirection)Types.forCodeName(AxisDirection.class, (String)string2, (boolean)false);
            }
        }
        return null;
    }

    final void mainDimensionFirst(Axis[] axisArray, int n) throws IOException, DataStoreException {
        int[] nArray;
        int n2 = this.sourceDimensions[0];
        int n3 = this.sourceDimensions[1];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            nArray = axisArray[i].sourceDimensions;
            if (nArray.length == 0) continue;
            int n4 = nArray[0];
            if (n4 == n3) {
                return;
            }
            boolean bl2 = bl = n4 == n2;
            if (bl) break;
        }
        if (!bl) {
            int[] nArray2 = Axis.sampleIndices(this.sourceSizes[0]);
            nArray = Axis.sampleIndices(this.sourceSizes[1]);
            double d = 0.0;
            double d2 = 0.0;
            int n5 = nArray2.length * nArray.length;
            while (--n5 >= 0) {
                int n6 = nArray2[n5 % nArray.length];
                int n7 = nArray[n5 / nArray.length];
                double d3 = this.coordinates.coordinateForAxis(n6, n7);
                d += this.coordinates.coordinateForAxis(n6 + 1, n7) - d3;
                d2 += this.coordinates.coordinateForAxis(n6, n7 + 1) - d3;
            }
            if (!(Math.abs(d2) > Math.abs(d))) {
                return;
            }
        }
        ArraysExt.swap(this.sourceSizes, 0, 1);
        ArraysExt.swap(this.sourceDimensions, 0, 1);
    }

    private static int[] sampleIndices(int n) {
        int n2;
        if (n >= 0) {
            if (n <= 1) {
                return ArraysExt.EMPTY_INT;
            }
            if (n <= 4) {
                return ArraysExt.range(0, n - 1);
            }
            n2 = n - 2;
        } else {
            n2 = 0x7FFFFFFE;
        }
        return new int[]{0, n >>> 1, n2};
    }

    final int getMainDirection() {
        return this.sourceDimensions.length < 2 || this.sourceDimensions[0] <= this.sourceDimensions[1] ? 0 : 1;
    }

    public final int getDimension() {
        return this.sourceDimensions.length;
    }

    private int getSizeProduct(int n) {
        int n2 = 1;
        while (n < this.sourceSizes.length) {
            n2 = Math.multiplyExact(n2, this.getSize(n++));
        }
        return n2;
    }

    private int getSize(int n) {
        int n2 = this.sourceSizes[n];
        if (n2 >= 0) {
            return n2;
        }
        throw new ArithmeticException(this.coordinates.errors().getString((short)188, 32));
    }

    public final long getSize() {
        return this.sourceSizes.length != 0 ? Integer.toUnsignedLong(this.sourceSizes[0]) : 0L;
    }

    @Override
    public final String getName() {
        return this.coordinates.getName().trim();
    }

    public final Unit<?> getUnit() {
        return this.coordinates.getUnit();
    }

    final boolean isSameUnitAndDirection(CoordinateSystemAxis coordinateSystemAxis) {
        if (!coordinateSystemAxis.getDirection().equals((Object)this.direction)) {
            return false;
        }
        Unit<?> unit = this.getUnit();
        return unit == null || coordinateSystemAxis.getUnit().equals(unit);
    }

    final boolean isWraparound() {
        if (this.abbreviation == '\u0000') {
            return AxisDirection.EAST.equals((Object)AxisDirections.absolute((AxisDirection)this.direction)) && Units.isAngular(this.getUnit());
        }
        return this.abbreviation == '\u03bb';
    }

    private double wraparoundRange() {
        if (this.isWraparound()) {
            double d = 360.0;
            Unit<?> unit = this.getUnit();
            if (unit != null) {
                try {
                    d = unit.getConverterToAny(Units.DEGREE).convert(d);
                }
                catch (IncommensurableException incommensurableException) {
                    this.warning((Exception)((Object)incommensurableException), (short)70, unit);
                    return Double.NaN;
                }
            }
            return d;
        }
        return Double.NaN;
    }

    final boolean isCellCorner() throws IOException, DataStoreException {
        boolean bl;
        double d;
        switch (this.abbreviation) {
            case '\u03bb': {
                d = -180.0;
                bl = true;
                break;
            }
            case '\u03c6': {
                d = -90.0;
                bl = false;
                break;
            }
            default: {
                return false;
            }
        }
        Vector vector = this.read();
        int n = vector.size();
        if (n != 0) {
            Object object = this.getUnit();
            if (object == null) {
                object = Units.DEGREE;
            }
            try {
                UnitConverter unitConverter = object.getConverterToAny(Units.DEGREE);
                if (bl && unitConverter.convert(vector.doubleValue(n - 1)) > 180.0) {
                    d = 0.0;
                }
                return unitConverter.convert(vector.doubleValue(0)) == d;
            }
            catch (IncommensurableException incommensurableException) {
                this.warning((Exception)((Object)incommensurableException), (short)70, object);
            }
        }
        return false;
    }

    final CoordinateSystemAxis toISO(CSFactory cSFactory, int n) throws DataStoreException, FactoryException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2 = this.getName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", string2);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        String string3 = this.coordinates.getAttributeAsString("standard_name");
        if (string3 != null) {
            string = new NamedIdentifier((Citation)Citations.NETCDF, (CharSequence)string3);
            if (string3.equals(string2)) {
                hashMap.put("name", string);
            } else {
                arrayList.add(string);
            }
        }
        if ((string = this.coordinates.getAttributeAsString("long_name")) != null && !Axis.similar(string, string2)) {
            hashMap.put("description", string);
            if (!Axis.similar(string, string3)) {
                arrayList.add((String)new NamedIdentifier(null, (CharSequence)string));
            }
        }
        if (!arrayList.isEmpty()) {
            hashMap.put("alias", arrayList.toArray(new GenericName[arrayList.size()]));
        }
        if ((object3 = this.getUnit()) == null) {
            switch (this.abbreviation) {
                case '\u03a9': 
                case '\u03b8': 
                case '\u03bb': 
                case '\u03c6': {
                    object3 = Units.DEGREE;
                    break;
                }
                case 'D': 
                case 'E': 
                case 'H': 
                case 'N': 
                case 'h': 
                case 'r': {
                    object3 = Units.METRE;
                    break;
                }
                case 't': {
                    object3 = Units.SECOND;
                    break;
                }
                case 'x': 
                case 'y': {
                    object2 = this.coordinates.read();
                    object = ((Vector)object2).increment(0.0);
                    if (object == null || ((Number)object).doubleValue() != 1.0) break;
                    object3 = Units.PIXEL;
                    break;
                }
            }
        }
        if ((object2 = this.direction) == null) {
            switch (n) {
                case 0: {
                    object2 = AxisDirection.COLUMN_POSITIVE;
                    break;
                }
                case 1: {
                    object2 = AxisDirection.ROW_POSITIVE;
                }
            }
        }
        object = this.abbreviation != '\u0000' ? Character.toString(this.abbreviation).intern() : (object2 != null && object3 != null ? AxisDirections.suggestAbbreviation((String)string2, (AxisDirection)object2, object3) : null);
        return cSFactory.createCoordinateSystemAxis(hashMap, (String)object, (AxisDirection)object2, object3);
    }

    final boolean trySetTransform(Matrix matrix, int n, int n2, List<MathTransform> list) throws IOException, DataStoreException {
        switch (this.getDimension()) {
            case 0: {
                return true;
            }
            case 1: {
                Vector vector = this.read();
                int n3 = n - this.sourceDimensions[0];
                if (this.coordinates.trySetTransform(matrix, n3, n2, vector)) {
                    return true;
                }
                list.add((MathTransform)MathTransforms.interpolate(null, (double[])vector.doubleValues()));
                return false;
            }
            case 2: {
                int n4;
                int n5;
                Vector vector = this.read();
                int[] nArray = vector.repetitions(this.sourceSizes);
                long l = 1L;
                int[] nArray2 = nArray;
                int n6 = nArray2.length;
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = nArray2[n5];
                    l = Math.multiplyExact(l, (long)n4);
                }
                int n7 = this.getMainDirection();
                for (n6 = 0; n6 <= 1; ++n6) {
                    int n8;
                    int n9;
                    n5 = this.getSize(n7 ^ n6);
                    n4 = this.getSize(n7 ^ n6 ^ 1);
                    if (l % (long)n5 != 0L) continue;
                    if (nArray.length >= 2) {
                        n9 = n4;
                        n8 = n5;
                    } else {
                        n9 = n5;
                        n8 = 1;
                    }
                    vector = vector.subSampling(0, n8, n9);
                    if (this.coordinates.trySetTransform(matrix, n - n6, n2, vector)) {
                        return true;
                    }
                    list.add((MathTransform)MathTransforms.interpolate(null, (double[])vector.doubleValues()));
                    return false;
                }
                break;
            }
        }
        list.add(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MathTransform createLocalizationGrid(Axis axis) throws IOException, FactoryException, DataStoreException {
        int n;
        int n2;
        if (this.getDimension() != 2 || axis.getDimension() != 2) {
            return null;
        }
        int n3 = axis.sourceDimensions[0];
        int n4 = this.sourceDimensions[0];
        if ((n3 != n4 | (n2 = axis.sourceDimensions[1]) != (n = this.sourceDimensions[1])) & (n3 != n | n2 != n4)) {
            return null;
        }
        int n5 = n4 <= n ? 0 : 1;
        int n6 = n3 <= n2 ? 0 : 1;
        int n7 = this.getSize(n5 ^ 1);
        int n8 = this.getSize(n5);
        if (axis.sourceSizes[n6 ^ 1] != n7 || axis.sourceSizes[n6] != n8) {
            this.warning(null, (short)82, this.getName(), axis.getName());
            return null;
        }
        GridCacheKey gridCacheKey = new GridCacheKey(n7, n8, this, axis);
        Decoder decoder = this.coordinates.decoder;
        MathTransform mathTransform = gridCacheKey.cached(decoder);
        if (mathTransform != null) {
            return mathTransform;
        }
        long l = System.nanoTime();
        Vector vector = this.read();
        Vector vector2 = axis.read();
        Set<Linearizer> set = decoder.convention().linearizers(decoder);
        GridCacheKey.Global global = new GridCacheKey.Global(gridCacheKey, vector, vector2, set);
        Cache.Handler<MathTransform> handler = global.lock();
        try {
            mathTransform = handler.peek();
            if (mathTransform == null) {
                LocalizationGridBuilder localizationGridBuilder = new LocalizationGridBuilder(n7, n8);
                localizationGridBuilder.setControlPoints(new Vector[]{vector, vector2});
                double d = this.wraparoundRange();
                if (!Double.isNaN(d)) {
                    localizationGridBuilder.resolveWraparoundAxis(0, n5, d);
                }
                if (!Double.isNaN(d = axis.wraparoundRange())) {
                    localizationGridBuilder.resolveWraparoundAxis(1, n6, d);
                }
                MathTransformFactory mathTransformFactory = decoder.getMathTransformFactory();
                if (!set.isEmpty()) {
                    Linearizer.applyTo(set, mathTransformFactory, localizationGridBuilder, this, axis);
                }
                localizationGridBuilder.setDesiredPrecision(0.001);
                mathTransform = localizationGridBuilder.create(mathTransformFactory);
                mathTransform = gridCacheKey.cache(decoder, mathTransform);
            }
        }
        finally {
            handler.putAndUnlock(mathTransform);
        }
        decoder.performance(Grid.class, "getGridGeometry", (short)22, l);
        return mathTransform;
    }

    private void warning(Exception exception, short s, Object ... objectArray) {
        this.coordinates.error(Variable.class, "getGridGeometry", exception, s, objectArray);
    }

    final Vector read() throws IOException, DataStoreException {
        TransferFunction transferFunction = this.coordinates.getTransferFunction();
        if (TransferFunctionType.LINEAR.equals((Object)transferFunction.getType())) {
            Vector vector = this.coordinates.read();
            vector = vector.subList(0, this.getSizeProduct(0));
            vector = vector.transform(transferFunction.getScale(), transferFunction.getOffset());
            return vector;
        }
        throw new DataStoreException(this.coordinates.resources().getString((short)18, this.getName()));
    }

    public boolean equals(Object object) {
        if (object instanceof Axis) {
            Axis axis = (Axis)object;
            return axis.abbreviation == this.abbreviation && axis.direction == this.direction && Arrays.equals(axis.sourceDimensions, this.sourceDimensions) && Arrays.equals(axis.sourceSizes, this.sourceSizes) && this.coordinates.equals(axis.coordinates);
        }
        return false;
    }

    public int hashCode() {
        return this.abbreviation + Arrays.hashCode(this.sourceDimensions) + Arrays.hashCode(this.sourceSizes);
    }
}

