/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.AbstractGridResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.geotiff.Compression;
import org.apache.sis.storage.geotiff.GridGeometryBuilder;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.DateType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class ImageFileDirectory
extends AbstractGridResource {
    private static final byte TILE = 1;
    private static final byte STRIP = 2;
    private static final byte SIGNED = 1;
    private static final byte UNSIGNED = 0;
    private static final byte FLOAT = 3;
    private final Reader reader;
    private final GenericName identifier;
    boolean hasDeferredEntries;
    private long imageWidth = -1L;
    private long imageHeight = -1L;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private Vector tileOffsets;
    private Vector tileByteCounts;
    private byte tileTagFamily;
    private boolean isPlanar;
    private byte sampleFormat;
    private boolean reverseBitsOrder;
    private short bitsPerSample;
    private short samplesPerPixel;
    private Vector extraSamples;
    private byte photometricInterpretation = (byte)-1;
    private Vector colorMap;
    private short cellWidth = (short)-1;
    private short cellHeight = (short)-1;
    private Vector minValues;
    private Vector maxValues;
    private boolean isMinSpecified;
    private boolean isMaxSpecified;
    private double resolution = Double.NaN;
    private Unit<Length> resolutionUnit = Units.INCH;
    private Compression compression;
    private GridGeometryBuilder referencing;
    private List<SampleDimension> sampleDimensions;

    private GridGeometryBuilder referencing() {
        if (this.referencing == null) {
            this.referencing = new GridGeometryBuilder(this.reader);
        }
        return this.referencing;
    }

    ImageFileDirectory(Reader reader, int n) {
        super(reader.owner.listeners());
        this.reader = reader;
        this.identifier = reader.nameFactory.createLocalName(reader.owner.identifier, (CharSequence)String.valueOf(n + 1));
    }

    private ChannelDataInput input() {
        return this.reader.input;
    }

    private String filename() {
        return this.input().filename;
    }

    private Charset encoding() {
        return this.reader.owner.encoding;
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    Object addEntry(short s, Type type, long l) throws IOException, ParseException, DataStoreException {
        block0 : switch (s) {
            case 284: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    case 1: {
                        this.isPlanar = false;
                        break block0;
                    }
                    case 2: {
                        this.isPlanar = true;
                        break block0;
                    }
                }
                return n;
            }
            case 256: {
                this.imageWidth = type.readUnsignedLong(this.input(), l);
                break;
            }
            case 257: {
                this.imageHeight = type.readUnsignedLong(this.input(), l);
                break;
            }
            case 322: {
                this.setTileTagFamily((byte)1);
                this.tileWidth = type.readInt(this.input(), l);
                break;
            }
            case 323: {
                this.setTileTagFamily((byte)1);
                this.tileHeight = type.readInt(this.input(), l);
                break;
            }
            case 278: {
                this.setTileTagFamily((byte)2);
                this.tileHeight = type.readInt(this.input(), l);
                break;
            }
            case 324: {
                this.setTileTagFamily((byte)1);
                this.tileOffsets = type.readVector(this.input(), l);
                break;
            }
            case 273: {
                this.setTileTagFamily((byte)2);
                this.tileOffsets = type.readVector(this.input(), l);
                break;
            }
            case 325: {
                this.setTileTagFamily((byte)1);
                this.tileByteCounts = type.readVector(this.input(), l);
                break;
            }
            case 279: {
                this.setTileTagFamily((byte)2);
                this.tileByteCounts = type.readVector(this.input(), l);
                break;
            }
            case 259: {
                long l2 = type.readLong(this.input(), l);
                this.compression = Compression.valueOf(l2);
                if (this.compression != null) break;
                return l2;
            }
            case 266: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    case 1: {
                        this.reverseBitsOrder = false;
                        break block0;
                    }
                    case 2: {
                        this.reverseBitsOrder = true;
                        break block0;
                    }
                }
                return n;
            }
            case 339: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    default: {
                        return n;
                    }
                    case 1: {
                        this.sampleFormat = 0;
                        break block0;
                    }
                    case 2: {
                        this.sampleFormat = 1;
                        break block0;
                    }
                    case 3: {
                        this.sampleFormat = (byte)3;
                        break block0;
                    }
                    case 4: 
                }
                this.warning(Level.WARNING, (short)25, this.filename());
                break;
            }
            case 258: {
                Vector vector = type.readVector(this.input(), l);
                this.bitsPerSample = vector.shortValue(0);
                int n = vector.size();
                for (int i = 1; i < n; ++i) {
                    if (vector.shortValue(i) == this.bitsPerSample) continue;
                    throw new DataStoreContentException(this.reader.resources().getString((short)3, "BitsPerSample", this.filename(), vector));
                }
                break;
            }
            case 277: {
                this.samplesPerPixel = type.readShort(this.input(), l);
                break;
            }
            case 338: {
                this.extraSamples = type.readVector(this.input(), l);
                break;
            }
            case 262: {
                short s2 = type.readShort(this.input(), l);
                if (s2 < 0 || s2 > 127) {
                    return s2;
                }
                this.photometricInterpretation = (byte)s2;
                break;
            }
            case 320: {
                this.colorMap = type.readVector(this.input(), l);
                break;
            }
            case 280: 
            case 340: {
                this.minValues = ImageFileDirectory.extremum(this.minValues, type.readVector(this.input(), l), false);
                this.isMinSpecified = true;
                break;
            }
            case 281: 
            case 341: {
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, type.readVector(this.input(), l), true);
                this.isMaxSpecified = true;
                break;
            }
            case 254: {
                break;
            }
            case 255: {
                break;
            }
            case -30801: {
                this.referencing().keyDirectory = type.readVector(this.input(), l);
                break;
            }
            case -30800: {
                this.referencing().numericParameters = type.readVector(this.input(), l);
                break;
            }
            case -30799: {
                CharSequence[] charSequenceArray = type.readString(this.input(), l, this.encoding());
                switch (charSequenceArray.length) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.referencing().asciiParameters = charSequenceArray[0];
                        break block0;
                    }
                }
                this.referencing().asciiParameters = String.join((CharSequence)"\u0000", charSequenceArray).concat("\u0000");
                break;
            }
            case 274: {
                break;
            }
            case -31272: {
                int n;
                Vector vector = type.readVector(this.input(), l);
                switch (vector.size()) {
                    case 6: 
                    case 9: {
                        n = 3;
                        break;
                    }
                    case 12: 
                    case 16: {
                        n = 4;
                        break;
                    }
                    default: {
                        return vector;
                    }
                }
                this.referencing().setGridToCRS(vector, n);
                break;
            }
            case -31986: {
                Vector vector = type.readVector(this.input(), l);
                int n = vector.size();
                if (n < 2 || n > 3) {
                    return vector;
                }
                this.referencing().setScaleFactors(vector);
                break;
            }
            case -31614: {
                this.referencing().modelTiePoints = type.readVector(this.input(), l);
                break;
            }
            case 270: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addTitle(string);
                }
                break;
            }
            case 315: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addAuthor(string);
                }
                break;
            }
            case -32104: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.parseLegalNotice(string);
                }
                break;
            }
            case 306: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addCitationDate(this.reader.getDateFormat().parse(string), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
                }
                break;
            }
            case 316: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addHostComputer(string);
                }
                break;
            }
            case 305: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addSoftwareReference(string);
                }
                break;
            }
            case 271: {
                break;
            }
            case 272: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.reader.metadata.addInstrument(null, string);
                }
                break;
            }
            case 282: 
            case 283: {
                double d = type.readDouble(this.input(), l);
                if (!Double.isNaN(this.resolution) && !(d > this.resolution)) break;
                this.resolution = d;
                break;
            }
            case 296: {
                short s3 = type.readShort(this.input(), l);
                switch (s3) {
                    case 1: {
                        this.resolutionUnit = null;
                        break block0;
                    }
                    case 2: {
                        this.resolutionUnit = Units.INCH;
                        break block0;
                    }
                    case 3: {
                        this.resolutionUnit = Units.CENTIMETRE;
                        break block0;
                    }
                }
                return s3;
            }
            case 263: {
                short s4 = type.readShort(this.input(), l);
                switch (s4) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (this.cellWidth < 0 && this.cellHeight < 0) break;
                        return null;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        return s4;
                    }
                }
                this.cellWidth = this.cellHeight = (short)(-s4);
                break;
            }
            case 264: {
                this.cellWidth = type.readShort(this.input(), l);
                break;
            }
            case 265: {
                this.cellHeight = type.readShort(this.input(), l);
                break;
            }
            case 288: 
            case 289: 
            case 290: 
            case 291: {
                this.warning(Level.FINE, (short)7, Tags.name(s));
            }
        }
        return null;
    }

    private void setTileTagFamily(byte by) throws DataStoreContentException {
        if (this.tileTagFamily != by && this.tileTagFamily != 0) {
            throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
        }
        this.tileTagFamily = by;
    }

    private static Vector extremum(Vector vector, Vector vector2, boolean bl) {
        if (vector != null) {
            int n = vector2.size();
            int n2 = vector.size();
            if (n2 > n) {
                n2 = n;
                Vector vector3 = vector;
                vector = vector2;
                vector2 = vector3;
            }
            while (--n2 >= 0) {
                double d = vector.doubleValue(n2);
                double d2 = vector2.doubleValue(n2);
                if (!Double.isNaN(d2) && !(bl ? d > d2 : d < d2)) continue;
                vector2.set(n2, (Number)d);
            }
        }
        return vector2;
    }

    private long pixelToByteCount(long l) {
        return (l = Math.multiplyExact(l, (long)(this.samplesPerPixel * this.bitsPerSample))) % 8L == 0L ? l / 8L : -1L;
    }

    private int computeTileSize(int n) {
        int n2 = this.tileByteCounts.size();
        if (n2 != 0) {
            long l = this.tileByteCounts.longValue(0);
            int n3 = 0;
            do {
                if (++n3 != n2) continue;
                long l2 = this.pixelToByteCount(n);
                if (l % l2 != 0L) break;
                return Math.toIntExact(l / l2);
            } while (this.tileByteCounts.longValue(n3) == (long)n2);
        }
        return -1;
    }

    final void validateMandatoryTags() throws DataStoreContentException {
        int n;
        long l;
        int n2;
        short s;
        short s2;
        if (this.imageWidth < 0L) {
            throw this.missingTag((short)256);
        }
        if (this.imageHeight < 0L) {
            throw this.missingTag((short)257);
        }
        switch (this.tileTagFamily) {
            case 2: {
                if (this.tileWidth < 0) {
                    this.tileWidth = Math.toIntExact(this.imageWidth);
                }
                if (this.tileHeight < 0) {
                    this.tileHeight = Math.toIntExact(this.imageHeight);
                }
                s2 = 273;
                s = 279;
                break;
            }
            case 1: {
                s2 = 324;
                s = 325;
                break;
            }
            default: {
                throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
            }
        }
        if (this.tileOffsets == null) {
            throw this.missingTag(s2);
        }
        if (this.samplesPerPixel == 0) {
            this.samplesPerPixel = 1;
            this.missingTag((short)277, 1L, false);
        }
        if (this.bitsPerSample == 0) {
            this.bitsPerSample = 1;
            this.missingTag((short)258, 1L, false);
        }
        if (this.colorMap != null) {
            this.ensureSameLength((short)320, (short)258, this.colorMap.size(), 3 * (1 << this.bitsPerSample));
        }
        if (this.sampleFormat != 3) {
            long l2;
            long l3;
            if (this.sampleFormat == 0) {
                l3 = 0L;
                l2 = -1L;
            } else {
                l3 = Long.MIN_VALUE;
                l2 = Long.MAX_VALUE;
            }
            int n3 = 64 - this.bitsPerSample;
            if (n3 >= 0 && n3 < 64 && (l3 >>>= n3) < (l2 >>>= n3)) {
                this.minValues = ImageFileDirectory.extremum(this.minValues, Vector.createSequence((Number)l3, (Number)0, (int)this.samplesPerPixel), false);
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, Vector.createSequence((Number)l2, (Number)0, (int)this.samplesPerPixel), true);
            }
        }
        int n4 = n2 = !this.isPlanar && this.compression.equals((Object)Compression.NONE) ? 0 : 8;
        if (this.tileWidth < 0) {
            n2 |= 1;
        }
        if (this.tileHeight < 0) {
            n2 |= 2;
        }
        if (this.tileByteCounts == null) {
            n2 |= 4;
        }
        switch (n2) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.tileWidth = this.computeTileSize(this.tileHeight);
                this.missingTag((short)322, this.tileWidth, true);
                break;
            }
            case 2: {
                this.tileHeight = this.computeTileSize(this.tileWidth);
                this.missingTag((short)323, this.tileHeight, true);
                break;
            }
            case 4: {
                l = this.pixelToByteCount(Math.multiplyExact(this.tileWidth, this.tileHeight));
                long[] lArray = new long[this.tileOffsets.size()];
                Arrays.fill(lArray, l);
                this.tileByteCounts = Vector.create((Object)lArray, (boolean)true);
                this.missingTag(s, l, true);
                break;
            }
            default: {
                short s3;
                switch (Integer.lowestOneBit(n2)) {
                    case 1: {
                        s3 = 322;
                        break;
                    }
                    case 2: {
                        s3 = 323;
                        break;
                    }
                    default: {
                        s3 = s;
                    }
                }
                throw this.missingTag(s3);
            }
        }
        this.ensureSameLength(s2, s, this.tileOffsets.size(), this.tileByteCounts.size());
        l = Math.multiplyExact(Math.addExact(this.imageWidth, (long)(this.tileWidth - 1)) / (long)this.tileWidth, Math.addExact(this.imageHeight, (long)(this.tileHeight - 1)) / (long)this.tileHeight);
        if (this.isPlanar) {
            l = Math.multiplyExact(l, (long)this.samplesPerPixel);
        }
        if ((long)(n = Math.min(this.tileOffsets.size(), this.tileByteCounts.size())) != l) {
            throw new DataStoreContentException(this.reader.resources().getString((short)18, this.filename(), l, n));
        }
        if (this.referencing != null && !this.referencing.validateMandatoryTags()) {
            throw this.missingTag((short)-31614);
        }
    }

    final void completeMetadata(MetadataBuilder metadataBuilder, Locale locale) throws DataStoreContentException, FactoryException {
        metadataBuilder.newCoverage(false);
        if (this.compression != null) {
            metadataBuilder.addCompression(this.compression.name().toLowerCase(locale));
        }
        int n = 0;
        while (n < this.samplesPerPixel) {
            metadataBuilder.newSampleDimension();
            metadataBuilder.setBitPerSample(this.bitsPerSample);
            if (this.isMinSpecified) {
                metadataBuilder.addMinimumSampleValue(this.minValues.doubleValue(Math.min(n, this.minValues.size() - 1)));
            }
            if (this.isMaxSpecified) {
                metadataBuilder.addMaximumSampleValue(this.maxValues.doubleValue(Math.min(n, this.maxValues.size() - 1)));
            }
            metadataBuilder.setBandIdentifier(++n);
        }
        if (!Double.isNaN(this.resolution) && this.resolutionUnit != null) {
            metadataBuilder.addResolution(this.resolutionUnit.getConverterTo(Units.METRE).convert(this.resolution));
        }
        switch (Math.min(this.cellWidth, this.cellHeight)) {
            case -1: {
                break;
            }
            case -3: {
                metadataBuilder.addProcessDescription((CharSequence)Resources.formatInternational((short)15));
                break;
            }
            default: {
                metadataBuilder.addProcessDescription((CharSequence)Resources.formatInternational((short)5, this.cellWidth >= 0 ? (int)this.cellWidth : 63, this.cellHeight >= 0 ? (int)this.cellHeight : 63));
            }
        }
        if (this.referencing != null) {
            this.getGridGeometry();
            this.referencing.completeMetadata(metadataBuilder);
        }
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        super.createMetadata(metadataBuilder);
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreContentException {
        if (this.referencing != null) {
            GridGeometry gridGeometry = this.referencing.gridGeometry;
            if (gridGeometry == null) {
                try {
                    gridGeometry = this.referencing.build(this.imageWidth, this.imageHeight);
                }
                catch (FactoryException factoryException) {
                    throw new DataStoreContentException(this.reader.resources().getString((short)26, this.filename()), factoryException);
                }
            }
            return gridGeometry;
        }
        return new GridGeometry(new GridExtent(this.imageWidth, this.imageHeight), null);
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreContentException {
        if (this.sampleDimensions == null) {
            Object[] objectArray = new SampleDimension[this.samplesPerPixel];
            SampleDimension.Builder builder = new SampleDimension.Builder();
            InternationalString internationalString = Vocabulary.formatInternational((short)111);
            int n = 0;
            while (n < this.samplesPerPixel) {
                builder.addQualitative((CharSequence)internationalString, this.minValues.get(Math.min(n, this.minValues.size() - 1)), this.maxValues.get(Math.min(n, this.maxValues.size() - 1)));
                objectArray[n++] = builder.setName(n).build();
                builder.clear();
            }
            this.sampleDimensions = UnmodifiableArrayList.wrap((Object[])objectArray);
        }
        return this.sampleDimensions;
    }

    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        throw new DataStoreException("Not yet implemented.");
    }

    private void warning(Level level, short s, Object ... objectArray) {
        LogRecord logRecord = this.reader.resources().getLogRecord(level, s, objectArray);
        this.reader.owner.warning(logRecord);
    }

    private void ensureSameLength(short s, short s2, int n, int n2) {
        if (n != n2) {
            this.warning(Level.WARNING, (short)11, Tags.name(s), Tags.name(s2), n, n2);
        }
    }

    private void missingTag(short s, long l, boolean bl) {
        this.warning(bl ? Level.WARNING : Level.FINE, bl ? (short)2 : 4, Tags.name(s), l);
    }

    private DataStoreContentException missingTag(short s) {
        return new DataStoreContentException(this.reader.resources().getString((short)13, this.filename(), Tags.name(s)));
    }
}

