/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.geotiff;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return (Resources)Resources.getBundle(Resources.class, (Locale)locale);
    }

    public static InternationalString formatInternational(short s) {
        return new International(s);
    }

    public static InternationalString formatInternational(short s, Object ... objectArray) {
        return new International(s, objectArray);
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = 8489130907339662434L;

        International(short s) {
            super(s);
        }

        International(short s, Object object) {
            super(s, object);
        }

        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short CanNotComputeGridGeometry_1 = 26;
        public static final short CircularImageReference_1 = 1;
        public static final short ComputedValueForAttribute_2 = 2;
        public static final short ConstantValueRequired_3 = 3;
        public static final short DefaultValueForAttribute_2 = 4;
        public static final short DitheringOrHalftoningApplied_2 = 5;
        public static final short IgnoredGeoKeys_1 = 6;
        public static final short IgnoredTag_1 = 7;
        public static final short InconsistentMapProjParameter_4 = 24;
        public static final short InconsistentTileStrip_1 = 8;
        public static final short InvalidGeoValue_2 = 9;
        public static final short ListTooShort_3 = 10;
        public static final short MismatchedLength_4 = 11;
        public static final short MissingGeoValue_1 = 12;
        public static final short MissingValue_2 = 13;
        public static final short NotTheEpsgValue_5 = 14;
        public static final short RandomizedProcessApplied = 15;
        public static final short UndefinedDataFormat_1 = 25;
        public static final short UnexpectedListOfValues_2 = 16;
        public static final short UnexpectedParameter_2 = 17;
        public static final short UnexpectedTileCount_3 = 18;
        public static final short UnknownCRS_1 = 22;
        public static final short UnsupportedCoordinateSystemKind_1 = 19;
        public static final short UnsupportedGeoKeyDirectory_1 = 20;
        public static final short UnsupportedGeoKeyStorage_1 = 21;
        public static final short UnsupportedProjectionMethod_1 = 23;

        private Keys() {
        }
    }
}

