/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.BufferedReader;
import java.io.Console;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.internal.referencing.Fallback;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.util.X364;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.resources.Errors;

@Fallback
public class ResourcesDownloader
extends InstallationResources {
    private static final String DOWNLOAD_URL = "http://repo1.maven.org/maven2/org/apache/sis/non-free/sis-epsg/1.0/sis-epsg-1.0.jar";
    private static final int DATABASE_SIZE = 20;
    private final Console console;
    private final Locale locale;
    private final boolean colors;
    private InstallationResources provider;
    private final Path directory;
    private final Map<String, Boolean> answers = new HashMap<String, Boolean>();
    private Boolean accepted;

    public ResourcesDownloader() {
        CommandRunner commandRunner = CommandRunner.instance;
        if (commandRunner != null) {
            this.locale = commandRunner.locale;
            this.colors = commandRunner.colors;
        } else {
            this.locale = Locale.getDefault();
            this.colors = false;
        }
        this.console = System.console();
        this.directory = DataDirectory.DATABASES.getDirectory();
    }

    public Set<String> getAuthorities() {
        return this.console != null && this.directory != null ? Collections.singleton("EPSG") : Collections.emptySet();
    }

    private static InstallationResources download() throws IOException {
        for (InstallationResources installationResources : ServiceLoader.load(InstallationResources.class, new URLClassLoader(new URL[]{new URL(DOWNLOAD_URL)}))) {
            if (installationResources.getClass().isAnnotationPresent(Fallback.class) || !installationResources.getAuthorities().contains("EPSG")) continue;
            return installationResources;
        }
        throw new FileNotFoundException();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized InstallationResources provider(String string, boolean bl) throws IOException {
        void var4_8;
        String string2;
        String string3;
        String string4;
        String string52;
        if (!"EPSG".equals(string)) {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"authority", (Object)string));
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.console.Messages", this.locale);
        if (this.answers.isEmpty()) {
            for (String string52 : resourceBundle.getString("yes").split("\\|")) {
                this.answers.put(string52, Boolean.TRUE);
            }
            for (String string52 : resourceBundle.getString("no").split("\\|")) {
                this.answers.put(string52, Boolean.FALSE);
            }
        }
        if (this.colors) {
            String string6 = X364.FOREGROUND_YELLOW.sequence();
            string4 = X364.UNDERLINE.sequence();
            string3 = X364.NO_UNDERLINE.sequence();
            string52 = X364.FOREGROUND_GREEN.sequence();
            string2 = X364.FOREGROUND_DEFAULT.sequence();
        } else {
            string2 = "";
            string52 = "";
            string3 = "";
            string4 = "";
            String string7 = "";
        }
        if (this.provider == null) {
            if (this.console == null) {
                throw new IllegalStateException();
            }
            this.console.format(resourceBundle.getString("install"), var4_8, 20, string4, this.directory, string3, string2);
            if (!this.accept(resourceBundle.getString("download"), var4_8, string2)) {
                this.console.format("%n", new Object[0]);
                throw new AccessDeniedException(null);
            }
            this.console.format(resourceBundle.getString("downloading"), string52, string2);
            this.provider = ResourcesDownloader.download();
        }
        if (bl && this.accepted == null) {
            String string8 = this.getLicense(string, this.locale, "text/plain");
            if (string8 == null) {
                this.accepted = Boolean.TRUE;
            } else {
                this.console.format("%n", new Object[0]).writer().write(string8);
                this.console.format("%n", new Object[0]);
                this.accepted = this.accept(resourceBundle.getString("accept"), var4_8, string2);
                if (this.accepted.booleanValue()) {
                    this.console.format(resourceBundle.getString("installing"), string52, string2);
                }
            }
        }
        if (this.accepted != null && !this.accepted.booleanValue()) {
            throw new AccessDeniedException(null);
        }
        return this.provider;
    }

    private boolean accept(String string, Object ... objectArray) {
        Boolean bl;
        while ((bl = this.answers.get(this.console.readLine(string, objectArray).toLowerCase(this.locale))) == null) {
        }
        return bl;
    }

    public String getLicense(String string, Locale locale, String string2) throws IOException {
        return this.provider(string, false).getLicense(string, locale, string2);
    }

    public String[] getResourceNames(String string) throws IOException {
        return this.provider(string, true).getResourceNames(string);
    }

    public Object getResource(String string, int n) throws IOException {
        return this.provider(string, true).getResource(string, n);
    }

    public BufferedReader openScript(String string, int n) throws IOException {
        return this.provider(string, true).openScript(string, n);
    }
}

