/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.proxy;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.plugin.apache.dubbo.cache.ApacheDubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.param.DubboParamResolveService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboProxyService {
    private final DubboParamResolveService dubboParamResolveService;

    public ApacheDubboProxyService(DubboParamResolveService dubboParamResolveService) {
        this.dubboParamResolveService = dubboParamResolveService;
    }

    public Mono<Object> genericInvoker(String body, MetaData metaData, ServerWebExchange exchange) throws ShenyuException {
        ReferenceConfig<GenericService> reference;
        Object referenceKey = metaData.getPath();
        String namespace = "";
        if (CollectionUtils.isNotEmpty((Collection)exchange.getRequest().getHeaders().get((Object)"namespace"))) {
            namespace = (String)exchange.getRequest().getHeaders().get((Object)"namespace").get(0);
            referenceKey = namespace + ":" + (String)referenceKey;
        }
        if (StringUtils.isEmpty((CharSequence)(reference = ApacheDubboConfigCache.getInstance().get((String)referenceKey)).getInterface())) {
            ApacheDubboConfigCache.getInstance().invalidate((String)referenceKey);
            reference = ApacheDubboConfigCache.getInstance().initRefN(metaData, namespace);
        }
        GenericService genericService = (GenericService)reference.get();
        Object pair = StringUtils.isBlank((CharSequence)metaData.getParameterTypes()) || ParamCheckUtils.bodyIsEmpty((String)body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : this.dubboParamResolveService.buildParameter(body, metaData.getParameterTypes());
        return Mono.fromFuture((CompletableFuture)this.invokeAsync(genericService, metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight()).thenApply(ret -> {
            Object result = ret;
            if (Objects.isNull(result)) {
                result = "dubbo has not return value!";
            }
            exchange.getAttributes().put("rpc_result", result);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return result;
        })).onErrorMap(exception -> exception instanceof GenericException ? new ShenyuException(((GenericException)exception).getExceptionMessage()) : new ShenyuException(exception));
    }

    private CompletableFuture<Object> invokeAsync(GenericService genericService, String method, String[] parameterTypes, Object[] args) throws GenericException {
        genericService.$invoke(method, parameterTypes, args);
        Future resultFromFuture = RpcContext.getContext().getFuture();
        return resultFromFuture instanceof CompletableFuture ? (CompletableFuture<Object>)resultFromFuture : CompletableFuture.completedFuture(resultFromFuture);
    }
}

