/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.api.config;

import java.util.Map;
import java.util.Properties;

public class RegisterConfig {
    private boolean enabled;
    private String registerType;
    private String serverLists;
    private Properties props = new Properties();

    public RegisterConfig() {
    }

    public RegisterConfig(String registerType, String serverLists, Properties props) {
        this.registerType = registerType;
        this.serverLists = serverLists;
        this.props = props;
    }

    public String getRegisterType() {
        return this.registerType;
    }

    public void setRegisterType(String registerType) {
        this.registerType = registerType;
    }

    public String getServerLists() {
        return this.serverLists;
    }

    public void setServerLists(String serverLists) {
        this.serverLists = serverLists;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        RegisterConfig registerConfig = (RegisterConfig)obj;
        if (!this.getRegisterType().equals(registerConfig.getRegisterType())) {
            return false;
        }
        if (!this.getServerLists().equals(registerConfig.getServerLists())) {
            return false;
        }
        if (this.getProps() == null && registerConfig.getProps() == null) {
            return true;
        }
        if (this.getProps() == null || registerConfig.getProps() == null) {
            return false;
        }
        if (this.getProps().entrySet().size() != registerConfig.getProps().entrySet().size()) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : this.getProps().entrySet()) {
            Object oldValue;
            Object newValue = entry.getValue();
            if (newValue.equals(oldValue = registerConfig.getProps().get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getRegisterType() != null ? this.getRegisterType().hashCode() : 0;
        result = 31 * result + (this.getServerLists() != null ? this.getServerLists().hashCode() : 0);
        if (this.getProps() != null) {
            for (Map.Entry<Object, Object> entry : this.getProps().entrySet()) {
                result = 31 * result + (entry.getKey() != null ? entry.getKey().hashCode() : 0);
                result = 31 * result + (entry.getValue() != null ? entry.getValue().hashCode() : 0);
            }
        }
        return result;
    }

    public static final class Builder {
        private boolean enabled;
        private String registerType;
        private String serverLists;
        private Properties props;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder registerType(String registerType) {
            this.registerType = registerType;
            return this;
        }

        public Builder serverLists(String serverLists) {
            this.serverLists = serverLists;
            return this;
        }

        public Builder props(Properties props) {
            this.props = props;
            return this;
        }

        public RegisterConfig build() {
            RegisterConfig registerConfig = new RegisterConfig();
            registerConfig.setEnabled(this.enabled);
            registerConfig.setRegisterType(this.registerType);
            registerConfig.setServerLists(this.serverLists);
            registerConfig.setProps(this.props);
            return registerConfig;
        }
    }
}

