/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.appinfo.RefreshableInstanceConfig;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.appinfo.providers.Archaius1VipAddressResolver;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.appinfo.providers.VipAddressResolver;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactories;

@Join
public class EurekaInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaInstanceRegisterRepository.class);
    private EurekaClient eurekaClient;
    private DefaultEurekaClientConfig eurekaClientConfig;
    private EurekaInstanceConfig eurekaInstanceConfig;
    private RestTemplateDiscoveryClientOptionalArgs restTemplateDiscoveryClientOptionalArgs;

    public void init(final RegisterConfig config) {
        this.eurekaInstanceConfig = new MyDataCenterInstanceConfig();
        this.eurekaClientConfig = new DefaultEurekaClientConfig(){

            public List<String> getEurekaServerServiceUrls(String zone) {
                return Arrays.asList(config.getServerLists().split(","));
            }

            public boolean shouldFetchRegistry() {
                return false;
            }
        };
        DefaultEurekaClientConfig eurekaClientNotRegisterEurekaConfig = new DefaultEurekaClientConfig(){

            public List<String> getEurekaServerServiceUrls(String zone) {
                return Arrays.asList(config.getServerLists().split(","));
            }

            public boolean shouldRegisterWithEureka() {
                return false;
            }
        };
        this.restTemplateDiscoveryClientOptionalArgs = new RestTemplateDiscoveryClientOptionalArgs((EurekaClientHttpRequestFactorySupplier)new DefaultEurekaClientHttpRequestFactorySupplier());
        this.eurekaClient = new DiscoveryClient(new ApplicationInfoManager(this.eurekaInstanceConfig, new EurekaConfigBasedInstanceInfoProvider(this.eurekaInstanceConfig).get()), (EurekaClientConfig)eurekaClientNotRegisterEurekaConfig, (TransportClientFactories)new RestTemplateTransportClientFactories(this.restTemplateDiscoveryClientOptionalArgs));
    }

    public void persistInstance(InstanceEntity instance) {
        InstanceInfo.Builder instanceInfoBuilder = this.instanceInfoBuilder();
        InstanceInfo instanceInfo = instanceInfoBuilder.setAppName(instance.getAppName()).setIPAddr(instance.getHost()).setHostName(instance.getHost()).setPort(instance.getPort().intValue()).setStatus(InstanceInfo.InstanceStatus.UP).build();
        LeaseInfo.Builder leaseInfoBuilder = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(this.eurekaInstanceConfig.getLeaseRenewalIntervalInSeconds()).setDurationInSecs(this.eurekaInstanceConfig.getLeaseExpirationDurationInSeconds());
        instanceInfo.setLeaseInfo(leaseInfoBuilder.build());
        ApplicationInfoManager applicationInfoManager = new ApplicationInfoManager(this.eurekaInstanceConfig, instanceInfo);
        new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)this.eurekaClientConfig, (TransportClientFactories)new RestTemplateTransportClientFactories(this.restTemplateDiscoveryClientOptionalArgs));
    }

    public InstanceInfo.Builder instanceInfoBuilder() {
        String defaultAddress;
        InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder((VipAddressResolver)new Archaius1VipAddressResolver());
        String instanceId = this.eurekaInstanceConfig.getInstanceId();
        if (StringUtils.isEmpty((String)instanceId)) {
            DataCenterInfo dataCenterInfo = this.eurekaInstanceConfig.getDataCenterInfo();
            instanceId = dataCenterInfo instanceof UniqueIdentifier ? ((UniqueIdentifier)dataCenterInfo).getId() : this.eurekaInstanceConfig.getHostName(false);
        }
        if (StringUtils.isEmpty((String)(defaultAddress = this.eurekaInstanceConfig instanceof RefreshableInstanceConfig ? ((RefreshableInstanceConfig)this.eurekaInstanceConfig).resolveDefaultAddress(false) : this.eurekaInstanceConfig.getHostName(false)))) {
            defaultAddress = this.eurekaInstanceConfig.getIpAddress();
        }
        builder.setNamespace(this.eurekaInstanceConfig.getNamespace()).setInstanceId(instanceId).setAppName(this.eurekaInstanceConfig.getAppname()).setAppGroupName(this.eurekaInstanceConfig.getAppGroupName()).setDataCenterInfo(this.eurekaInstanceConfig.getDataCenterInfo()).setIPAddr(this.eurekaInstanceConfig.getIpAddress()).setHostName(defaultAddress).setPort(this.eurekaInstanceConfig.getNonSecurePort()).enablePort(InstanceInfo.PortType.UNSECURE, this.eurekaInstanceConfig.isNonSecurePortEnabled()).setSecurePort(this.eurekaInstanceConfig.getSecurePort()).enablePort(InstanceInfo.PortType.SECURE, this.eurekaInstanceConfig.getSecurePortEnabled()).setVIPAddress(this.eurekaInstanceConfig.getVirtualHostName()).setSecureVIPAddress(this.eurekaInstanceConfig.getSecureVirtualHostName()).setHomePageUrl(this.eurekaInstanceConfig.getHomePageUrlPath(), this.eurekaInstanceConfig.getHomePageUrl()).setStatusPageUrl(this.eurekaInstanceConfig.getStatusPageUrlPath(), this.eurekaInstanceConfig.getStatusPageUrl()).setASGName(this.eurekaInstanceConfig.getASGName()).setHealthCheckUrls(this.eurekaInstanceConfig.getHealthCheckUrlPath(), this.eurekaInstanceConfig.getHealthCheckUrl(), this.eurekaInstanceConfig.getSecureHealthCheckUrl());
        if (!this.eurekaInstanceConfig.isInstanceEnabledOnit()) {
            InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.STARTING;
            LOGGER.info("Setting initial instance status as: {}", (Object)initialStatus);
            builder.setStatus(initialStatus);
        } else {
            LOGGER.info("Setting initial instance status as: {}. This may be too early for the instance to advertise itself as available. You would instead want to control this via a healthcheck handler.", (Object)InstanceInfo.InstanceStatus.UP);
        }
        for (Map.Entry mapEntry : this.eurekaInstanceConfig.getMetadataMap().entrySet()) {
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            if (!StringUtils.isNotEmpty((String)value)) continue;
            builder.add(key, value);
        }
        return builder;
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        return this.getInstances(selectKey);
    }

    private List<InstanceEntity> getInstances(String selectKey) {
        List instances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, selectKey, true);
        return instances.stream().map(i -> InstanceEntity.builder().appName(i.getAppName()).host(i.getHostName()).port(Integer.valueOf(i.getPort())).uri(this.getURI((InstanceInfo)i)).build()).collect(Collectors.toList());
    }

    private URI getURI(InstanceInfo instance) {
        boolean secure = instance.isPortEnabled(InstanceInfo.PortType.SECURE);
        String scheme = secure ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = secure ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getIPAddr(), port);
        return URI.create(uri);
    }

    public void close() {
        Optional.ofNullable(this.eurekaClient).ifPresent(EurekaClient::shutdown);
    }
}

