/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.RequestQueryCodecUtil;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

public final class RequestUrlUtils {
    private RequestUrlUtils() {
    }

    public static URI buildRequestUri(ServerWebExchange exchange, String domain) {
        Object path = domain;
        String rewriteUri = (String)exchange.getAttribute("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteUri})) {
            path = (String)path + rewriteUri;
        } else {
            ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
            assert (shenyuContext != null);
            String realUrl = shenyuContext.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = (String)path + realUrl;
            }
        }
        URI uri = exchange.getRequest().getURI();
        if (StringUtils.isNotEmpty((CharSequence)uri.getRawQuery()) && uri.getRawQuery().contains("%") || StringUtils.isNotEmpty((CharSequence)uri.getRawPath()) && uri.getRawPath().contains("%")) {
            path = (String)path + "?" + RequestQueryCodecUtil.getCodecQuery(exchange);
            return UriComponentsBuilder.fromUriString((String)path).build(true).toUri();
        }
        if (StringUtils.isNotEmpty((CharSequence)uri.getQuery())) {
            path = (String)path + "?" + uri.getQuery();
        }
        assert (path != null);
        return UriComponentsBuilder.fromUriString((String)path).build(false).toUri();
    }

    public static String getRewrittenRawPath(ServerWebExchange exchange) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        if (Objects.nonNull(shenyuContext)) {
            String rewriteContextPath = (String)exchange.getAttribute("rewrite_context_path");
            String rewriteUri = (String)exchange.getAttribute("rewrite_uri");
            if (StringUtils.isNotBlank((CharSequence)rewriteContextPath) && StringUtils.isNotBlank((CharSequence)rewriteUri)) {
                return rewriteContextPath + rewriteUri;
            }
            if (StringUtils.isNotBlank((CharSequence)rewriteContextPath)) {
                return rewriteContextPath + shenyuContext.getRealUrl();
            }
            String contextPath = (String)exchange.getAttribute("contextPath");
            if (StringUtils.isNotBlank((CharSequence)contextPath)) {
                return contextPath + shenyuContext.getRealUrl();
            }
        }
        return exchange.getRequest().getURI().getRawPath();
    }
}

