/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.console;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.MediaTypeUtils;
import org.apache.shenyu.plugin.logging.common.entity.CommonLoggingRuleHandle;
import org.apache.shenyu.plugin.logging.console.handler.LoggingConsolePluginDataHandler;
import org.apache.shenyu.plugin.logging.desensitize.api.enums.DataDesensitizeEnum;
import org.apache.shenyu.plugin.logging.desensitize.api.matcher.KeyWordMatch;
import org.apache.shenyu.plugin.logging.desensitize.api.utils.DataDesensitizeUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class LoggingConsolePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConsolePlugin.class);
    private static String dataDesensitizeAlg = DataDesensitizeEnum.CHARACTER_REPLACE.getDataDesensitizeAlg();

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CommonLoggingRuleHandle commonLoggingRuleHandle = (CommonLoggingRuleHandle)LoggingConsolePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        HashSet keywordSets = Sets.newHashSet();
        boolean desensitized = Boolean.FALSE;
        KeyWordMatch keyWordMatch = new KeyWordMatch(Collections.emptySet());
        if (Objects.nonNull(commonLoggingRuleHandle)) {
            String keywords = commonLoggingRuleHandle.getKeyword();
            boolean bl = desensitized = StringUtils.isNotBlank((CharSequence)keywords) && commonLoggingRuleHandle.getMaskStatus() != false;
            if (desensitized) {
                Collections.addAll(keywordSets, keywords.split(";"));
                dataDesensitizeAlg = Optional.ofNullable(commonLoggingRuleHandle.getMaskType()).orElse(DataDesensitizeEnum.MD5_ENCRYPT.getDataDesensitizeAlg());
                keyWordMatch = new KeyWordMatch((Set)keywordSets);
                LOG.info("current plugin:{}, keyword:{}, dataDesensitizedAlg:{}", new Object[]{this.named(), keywords, dataDesensitizeAlg});
            }
        }
        ServerHttpRequest request = exchange.getRequest();
        StringBuilder requestInfo = new StringBuilder().append(System.lineSeparator());
        requestInfo.append(this.getRequestUri(request, desensitized, keyWordMatch)).append(this.getRequestMethod(request, desensitized, keyWordMatch)).append(System.lineSeparator()).append(this.getRequestHeaders(request, desensitized, keyWordMatch)).append(System.lineSeparator()).append(this.getQueryParams(request, desensitized, keyWordMatch)).append(System.lineSeparator());
        LoggingServerHttpResponse loggingServerHttpResponse = new LoggingServerHttpResponse(exchange.getResponse(), requestInfo, desensitized, keyWordMatch);
        try {
            return chain.execute(exchange.mutate().request((ServerHttpRequest)new LoggingServerHttpRequest(request, requestInfo, desensitized, keyWordMatch)).response((ServerHttpResponse)loggingServerHttpResponse).build()).doOnError(loggingServerHttpResponse::logError);
        }
        catch (Exception e) {
            loggingServerHttpResponse.logError(e);
            throw e;
        }
    }

    public int getOrder() {
        return PluginEnum.LOGGING_CONSOLE.getCode();
    }

    public String named() {
        return PluginEnum.LOGGING_CONSOLE.getName();
    }

    private String getRequestMethod(ServerHttpRequest request, Boolean desensitized, KeyWordMatch keyWordMatch) {
        String requestMethod = "";
        if (Objects.nonNull(request.getMethod())) {
            requestMethod = DataDesensitizeUtils.desensitizeSingleKeyword((boolean)desensitized, (String)"requestMethod", (String)request.getMethod().toString(), (KeyWordMatch)keyWordMatch, (String)dataDesensitizeAlg);
        }
        return "Request Method: " + requestMethod + System.lineSeparator();
    }

    private String getRequestUri(ServerHttpRequest request, Boolean desensitized, KeyWordMatch keyWordMatch) {
        String requestUri = DataDesensitizeUtils.desensitizeSingleKeyword((boolean)desensitized, (String)"requestUri", (String)request.getURI().toString(), (KeyWordMatch)keyWordMatch, (String)dataDesensitizeAlg);
        return "Request Uri: " + requestUri + System.lineSeparator();
    }

    private String getQueryParams(ServerHttpRequest request, Boolean desensitized, KeyWordMatch keyWordMatch) {
        MultiValueMap params = request.getQueryParams();
        StringBuilder logInfo = new StringBuilder();
        if (!params.isEmpty()) {
            logInfo.append("[Query Params Start]").append(System.lineSeparator());
            params.forEach((key, value) -> {
                ArrayList list = Lists.newArrayList((Iterable)value);
                DataDesensitizeUtils.desensitizeList((boolean)desensitized, (String)key, (List)list, (KeyWordMatch)keyWordMatch, (String)dataDesensitizeAlg);
                logInfo.append((String)key).append(": ").append(StringUtils.join((Iterable)list, (String)",")).append(System.lineSeparator());
            });
            logInfo.append("[Query Params End]").append(System.lineSeparator());
        }
        return logInfo.toString();
    }

    private String getRequestHeaders(ServerHttpRequest request, Boolean desensitized, KeyWordMatch keyWordMatch) {
        HttpHeaders headers = request.getHeaders();
        StringBuilder logInfo = new StringBuilder();
        if (!headers.isEmpty()) {
            logInfo.append("[Request Headers Start]").append(System.lineSeparator());
            logInfo.append(this.getHeaders(headers, desensitized, keyWordMatch));
            logInfo.append("[Request Headers End]").append(System.lineSeparator());
        }
        return logInfo.toString();
    }

    private void print(String info) {
        LOG.info(info);
    }

    private String getHeaders(HttpHeaders headers, Boolean desensitized, KeyWordMatch keyWordMatch) {
        StringBuilder logInfo = new StringBuilder();
        Set entrySet = headers.entrySet();
        entrySet.forEach(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            value = Lists.newArrayList((Iterable)value);
            DataDesensitizeUtils.desensitizeList((boolean)desensitized, (String)key, (List)value, (KeyWordMatch)keyWordMatch, (String)dataDesensitizeAlg);
            logInfo.append(key).append(": ").append(StringUtils.join((Iterable)value, (String)",")).append(System.lineSeparator());
        });
        return logInfo.toString();
    }

    class LoggingServerHttpResponse
    extends ServerHttpResponseDecorator {
        private final StringBuilder logInfo;
        private final ServerHttpResponse serverHttpResponse;
        private final Boolean desensitized;
        private final KeyWordMatch keyWordMatch;

        LoggingServerHttpResponse(ServerHttpResponse delegate, StringBuilder logInfo, Boolean desensitized, KeyWordMatch keyWordMatch) {
            super(delegate);
            this.logInfo = logInfo;
            this.serverHttpResponse = delegate;
            this.desensitized = desensitized;
            this.keyWordMatch = keyWordMatch;
            this.logInfo.append(System.lineSeparator());
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            return super.writeWith(this.appendResponse(body));
        }

        @NonNull
        private Flux<? extends DataBuffer> appendResponse(Publisher<? extends DataBuffer> body) {
            this.logInfo.append(System.lineSeparator());
            this.logInfo.append("Response Code: ").append(this.serverHttpResponse.getStatusCode()).append(System.lineSeparator());
            this.logInfo.append(this.getResponseHeaders()).append(System.lineSeparator());
            MediaType mediaType = this.serverHttpResponse.getHeaders().getContentType();
            if (MediaTypeUtils.isByteType((MediaType)mediaType)) {
                return Flux.from(body).doFinally(signal -> {
                    this.logInfo.append("[Response Body Start]").append(System.lineSeparator());
                    this.logInfo.append("[bytes]").append(System.lineSeparator());
                    this.logInfo.append("[Response Body End]").append(System.lineSeparator());
                    LoggingConsolePlugin.this.print(this.logInfo.toString());
                });
            }
            BodyWriter writer = new BodyWriter();
            return Flux.from(body).doOnNext(buffer -> {
                try (DataBuffer.ByteBufferIterator bufferIterator = buffer.readableByteBuffers();){
                    bufferIterator.forEachRemaining(byteBuffer -> writer.write(byteBuffer.asReadOnlyBuffer()));
                }
            }).doFinally(signal -> {
                this.logInfo.append("[Response Body Start]").append(System.lineSeparator());
                String responseBody = DataDesensitizeUtils.desensitizeBody((boolean)this.desensitized, (String)writer.output(), (KeyWordMatch)this.keyWordMatch, (String)dataDesensitizeAlg);
                this.logInfo.append(responseBody).append(System.lineSeparator());
                this.logInfo.append("[Response Body End]").append(System.lineSeparator());
                LoggingConsolePlugin.this.print(this.logInfo.toString());
            });
        }

        public void logError(Throwable throwable) {
            HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            if (throwable instanceof ResponseStatusException) {
                httpStatus = ((ResponseStatusException)throwable).getStatusCode();
            }
            this.logInfo.append("Response Code: ").append(httpStatus).append(System.lineSeparator());
            this.logInfo.append(this.getResponseHeaders()).append(System.lineSeparator());
            this.logInfo.append("ERROR: ").append(System.lineSeparator());
            this.logInfo.append(throwable.getMessage()).append(System.lineSeparator());
        }

        private String getResponseHeaders() {
            return System.lineSeparator() + "[Response Headers Start]" + System.lineSeparator() + LoggingConsolePlugin.this.getHeaders(this.serverHttpResponse.getHeaders(), this.desensitized, this.keyWordMatch) + "[Response Headers End]" + System.lineSeparator();
        }
    }

    static class LoggingServerHttpRequest
    extends ServerHttpRequestDecorator {
        private final StringBuilder logInfo;
        private final Boolean desensitized;
        private final KeyWordMatch keyWordMatch;

        LoggingServerHttpRequest(ServerHttpRequest delegate, StringBuilder logInfo, Boolean desensitized, KeyWordMatch keyWordMatch) {
            super(delegate);
            this.logInfo = logInfo;
            this.desensitized = desensitized;
            this.keyWordMatch = keyWordMatch;
        }

        @NonNull
        public Flux<DataBuffer> getBody() {
            BodyWriter writer = new BodyWriter();
            return super.getBody().doOnNext(dataBuffer -> {
                try (DataBuffer.ByteBufferIterator bufferIterator = dataBuffer.readableByteBuffers();){
                    bufferIterator.forEachRemaining(byteBuffer -> writer.write(byteBuffer.asReadOnlyBuffer()));
                }
            }).doFinally(signal -> {
                if (!writer.isEmpty()) {
                    this.logInfo.append("[Request Body Start]").append(System.lineSeparator());
                    String requestBody = DataDesensitizeUtils.desensitizeBody((boolean)this.desensitized, (String)writer.output(), (KeyWordMatch)this.keyWordMatch, (String)dataDesensitizeAlg);
                    this.logInfo.append(requestBody).append(System.lineSeparator());
                    this.logInfo.append("[Request Body End]").append(System.lineSeparator());
                } else {
                    writer.output();
                }
            });
        }
    }

    static class BodyWriter {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.stream);
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        BodyWriter() {
        }

        void write(ByteBuffer buffer) {
            if (!this.isClosed.get()) {
                try {
                    this.channel.write(buffer);
                }
                catch (IOException e) {
                    this.isClosed.compareAndSet(false, true);
                    LOG.error("Parse Failed.", (Throwable)e);
                }
            }
        }

        boolean isEmpty() {
            return this.stream.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String output() {
            try {
                this.isClosed.compareAndSet(false, true);
                String string = this.stream.toString(StandardCharsets.UTF_8);
                return string;
            }
            catch (Exception e) {
                LOG.error("Write failed: ", (Throwable)e);
                String string = "Write failed: " + e.getMessage();
                return string;
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    LOG.error("Close stream error: ", (Throwable)e);
                }
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOG.error("Close channel error: ", (Throwable)e);
                }
            }
        }
    }
}

