/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.elasticsearch.config;

import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.plugin.logging.common.config.GenericGlobalConfig;

public class ElasticSearchLogCollectConfig {
    public static final ElasticSearchLogCollectConfig INSTANCE = new ElasticSearchLogCollectConfig();
    private ElasticSearchLogConfig elasticSearchLogConfig;

    public ElasticSearchLogConfig getElasticSearchLogConfig() {
        return Optional.ofNullable(this.elasticSearchLogConfig).orElse(new ElasticSearchLogConfig());
    }

    public void setElasticSearchLogConfig(ElasticSearchLogConfig elasticSearchLogConfig) {
        this.elasticSearchLogConfig = elasticSearchLogConfig;
    }

    public static class ElasticSearchLogConfig
    extends GenericGlobalConfig {
        private String host;
        private String port;
        private String username;
        private String password;
        private Boolean authCache;
        private String compressAlg;
        private String indexName;

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public String getCompressAlg() {
            return this.compressAlg;
        }

        public void setCompressAlg(String compressAlg) {
            this.compressAlg = compressAlg;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Boolean getAuthCache() {
            return this.authCache;
        }

        public void setAuthCache(Boolean authCache) {
            this.authCache = authCache;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return Boolean.TRUE;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return Boolean.FALSE;
            }
            ElasticSearchLogConfig that = (ElasticSearchLogConfig)((Object)o);
            return Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getCompressAlg(), that.getCompressAlg()) && Objects.equals(this.getPort(), that.getPort()) && Objects.equals(this.getSampleRate(), that.getSampleRate()) && Objects.equals(this.getBufferQueueSize(), that.getBufferQueueSize()) && Objects.equals(this.getMaxRequestBody(), that.getMaxRequestBody()) && Objects.equals(this.getMaxResponseBody(), that.getMaxResponseBody()) && Objects.equals(this.getIndexName(), that.getIndexName());
        }

        public int hashCode() {
            return Objects.hash(this.host, this.compressAlg, this.port);
        }
    }

    public static class LogApiConfig {
        private String index;
        private String sampleRate;

        public String getSampleRate() {
            return this.sampleRate;
        }

        public void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }
    }
}

