/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;

public class DubboCodecSupport {
    public static Serialization getRequestSerialization(URL url, Invocation invocation) {
        Object serializationTypeObj = invocation.get("serialization_id");
        if (serializationTypeObj != null) {
            return CodecSupport.getSerializationById((byte)((Byte)serializationTypeObj));
        }
        return url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(UrlUtils.serializationOrDefault(url));
    }

    public static Serialization getResponseSerialization(URL url, AppResponse appResponse) {
        Invocation invocation;
        Object serializationTypeObj;
        Object invocationObj = appResponse.getAttribute("invocation");
        if (invocationObj != null && (serializationTypeObj = (invocation = (Invocation)invocationObj).get("serialization_id")) != null) {
            return CodecSupport.getSerializationById((byte)((Byte)serializationTypeObj));
        }
        return url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(UrlUtils.serializationOrDefault(url));
    }
}

