/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.etcd;

import io.etcd.jetcd.Watch;
import io.etcd.jetcd.watch.WatchEvent;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.path.InstancePathConstants;
import org.apache.shenyu.registry.etcd.EtcdClient;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdInstanceRegisterRepository.class);
    private EtcdClient client;
    private final Map<String, List<InstanceEntity>> watcherInstanceRegisterMap = new HashMap<String, List<InstanceEntity>>();

    public void init(RegisterConfig config) {
        Properties props = config.getProps();
        long timeout = Long.parseLong(props.getProperty("etcdTimeout", "3000"));
        long ttl = Long.parseLong(props.getProperty("etcdTTL", "5"));
        this.client = new EtcdClient(config.getServerLists(), ttl, timeout);
    }

    public void persistInstance(InstanceEntity instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        String instancePath = InstancePathConstants.buildInstanceParentPath((String)instance.getAppName());
        String realNode = InstancePathConstants.buildRealNode((String)instancePath, (String)instanceNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.client.putEphemeral(realNode, nodeData);
        LOGGER.info("etcd client register success: {}", (Object)nodeData);
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        String watchKey = InstancePathConstants.buildInstanceParentPath((String)selectKey);
        Function<Map, List> getInstanceRegisterFun = childrenList -> childrenList.values().stream().map(x -> {
            InstanceEntity instanceEntity = (InstanceEntity)GsonUtils.getInstance().fromJson(x, InstanceEntity.class);
            instanceEntity.setUri(this.getURI((String)x, instanceEntity.getPort(), instanceEntity.getHost()));
            return instanceEntity;
        }).collect(Collectors.toList());
        if (this.watcherInstanceRegisterMap.containsKey(selectKey)) {
            return getInstanceRegisterFun.apply(this.client.getKeysMapByPrefix(watchKey));
        }
        Map<String, String> serverNodes = this.client.getKeysMapByPrefix(watchKey);
        this.client.watchKeyChanges(watchKey, Watch.listener(response -> {
            block4: for (WatchEvent event : response.getEvents()) {
                String value = event.getKeyValue().getValue().toString(StandardCharsets.UTF_8);
                String path = event.getKeyValue().getKey().toString(StandardCharsets.UTF_8);
                switch (event.getEventType()) {
                    case PUT: {
                        serverNodes.put(path, value);
                        LOGGER.info("watch key {} updated, value is {}", (Object)watchKey, (Object)value);
                        continue block4;
                    }
                    case DELETE: {
                        serverNodes.remove(path);
                        LOGGER.info("watch key {} deleted, key is {}", (Object)watchKey, (Object)path);
                        continue block4;
                    }
                }
            }
            this.watcherInstanceRegisterMap.put(selectKey, (List)getInstanceRegisterFun.apply(serverNodes));
        }));
        List instanceEntities = getInstanceRegisterFun.apply(serverNodes);
        this.watcherInstanceRegisterMap.put(selectKey, instanceEntities);
        return instanceEntities;
    }

    private URI getURI(String instanceRegisterJsonStr, int port, String host) {
        String scheme = instanceRegisterJsonStr.contains("https") || instanceRegisterJsonStr.contains("HTTPS") ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, host, port);
        return URI.create(uri);
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public void close() {
        this.client.close();
    }
}

