/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(EtcdClient.class);
    private final Client client;
    private final long ttl;
    private final long timeout;
    private long globalLeaseId;

    public EtcdClient(String url, long ttl, long timeout) {
        this.client = Client.builder().endpoints(url.split(",")).build();
        this.ttl = ttl;
        this.timeout = timeout;
        this.initLease();
    }

    private void initLease() {
        try {
            this.globalLeaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(this.ttl).get()).getID();
            this.client.getLeaseClient().keepAlive(this.globalLeaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse leaseKeepAliveResponse) {
                }

                public void onError(Throwable throwable) {
                    LOG.error("keep alive error", throwable);
                }

                public void onCompleted() {
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("initLease error.", (Throwable)e);
        }
    }

    public void watchKeyChanges(String key, Watch.Listener listener) {
        WatchOption option = WatchOption.newBuilder().isPrefix(true).build();
        this.client.getWatchClient().watch(this.bytesOf(key), option, listener);
    }

    public Map<String, String> getKeysMapByPrefix(String prefix) {
        GetOption getOption = GetOption.newBuilder().isPrefix(true).build();
        return this.getRange(prefix, getOption).getKvs().stream().collect(Collectors.toMap(e -> e.getKey().toString(StandardCharsets.UTF_8), e -> e.getValue().toString(StandardCharsets.UTF_8)));
    }

    public GetResponse getRange(String key, GetOption getOption) {
        try {
            return (GetResponse)this.client.getKVClient().get(this.bytesOf(key), getOption).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("etcd getRange key {} error", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public ByteSequence bytesOf(String val) {
        return ByteSequence.from((String)val, (Charset)UTF_8);
    }

    public void close() {
        this.client.close();
    }

    public void putEphemeral(String key, String value) {
        try {
            KV kvClient = this.client.getKVClient();
            kvClient.put(ByteSequence.from((String)key, (Charset)UTF_8), ByteSequence.from((String)value, (Charset)UTF_8), PutOption.newBuilder().withLeaseId(this.globalLeaseId).build()).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("putEphemeral(key:{},value:{}) error.", new Object[]{key, value, e});
        }
    }
}

