/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.nacos.NacosSyncDataService;
import org.apache.shenyu.sync.data.nacos.config.NacosConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={NacosSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.nacos", name={"url"})
public class NacosSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosSyncDataConfiguration.class);

    @Bean
    public SyncDataService nacosSyncDataService(ObjectProvider<ConfigService> configService, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers, ObjectProvider<ShenyuConfig> shenyuConfig) {
        LOGGER.info("you use nacos sync shenyu data.......");
        return new NacosSyncDataService((ConfigService)configService.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorSubscribers.getIfAvailable(), (List)discoveryUpstreamDataSubscribers.getIfAvailable(), (ShenyuConfig)shenyuConfig.getIfAvailable());
    }

    @Bean
    public ConfigService nacosConfigService(NacosConfig nacosConfig) throws Exception {
        Properties properties = new Properties();
        if (nacosConfig.getAcm() != null && nacosConfig.getAcm().isEnabled()) {
            properties.put("endpoint", nacosConfig.getAcm().getEndpoint());
            properties.put("namespace", nacosConfig.getAcm().getNamespace());
            properties.put("accessKey", nacosConfig.getAcm().getAccessKey());
            properties.put("secretKey", nacosConfig.getAcm().getSecretKey());
        } else {
            properties.put("serverAddr", nacosConfig.getUrl());
            if (StringUtils.isNotBlank((CharSequence)nacosConfig.getNamespace())) {
                properties.put("namespace", nacosConfig.getNamespace());
            }
            if (nacosConfig.getUsername() != null) {
                properties.put("username", nacosConfig.getUsername());
            }
            if (nacosConfig.getPassword() != null) {
                properties.put("password", nacosConfig.getPassword());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosConfig.getContextPath())) {
                properties.put("contextPath", nacosConfig.getContextPath());
            }
        }
        return NacosFactory.createConfigService((Properties)properties);
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.nacos")
    public NacosConfig nacosConfig() {
        return new NacosConfig();
    }
}

