/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryUpstreamDataRefresh
extends AbstractDataRefresh<DiscoverySyncData> {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryUpstreamDataRefresh.class);
    private final List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers;

    public DiscoveryUpstreamDataRefresh(List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        this.discoveryUpstreamDataSubscribers = discoveryUpstreamDataSubscribers;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.DISCOVER_UPSTREAM.name());
    }

    @Override
    protected ConfigData<DiscoverySyncData> fromJson(JsonObject data) {
        return (ConfigData)GsonUtils.getGson().fromJson((JsonElement)data, new TypeToken<ConfigData<DiscoverySyncData>>(){}.getType());
    }

    @Override
    protected void refresh(List<DiscoverySyncData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all plugin data cache");
            return;
        }
        data.forEach(d -> this.discoveryUpstreamDataSubscribers.forEach(dus -> dus.onSubscribe(d)));
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<DiscoverySyncData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.DISCOVER_UPSTREAM);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.PROXY_SELECTOR);
    }
}

