/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ThreadUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.AccessTokenManager;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.apache.shenyu.sync.data.http.refresh.DataRefreshFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpSyncDataService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSyncDataService.class);
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private ExecutorService executor;
    private final List<String> serverList;
    private final DataRefreshFactory factory;
    private final AccessTokenManager accessTokenManager;
    private final OkHttpClient okHttpClient;
    private final ShenyuConfig shenyuConfig;

    public HttpSyncDataService(HttpConfig httpConfig, PluginDataSubscriber pluginDataSubscriber, OkHttpClient okHttpClient, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers, AccessTokenManager accessTokenManager, ShenyuConfig shenyuConfig) {
        this.accessTokenManager = accessTokenManager;
        this.factory = new DataRefreshFactory(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers);
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)httpConfig.getUrl()));
        this.okHttpClient = okHttpClient;
        this.shenyuConfig = shenyuConfig;
        this.start();
    }

    private void start() {
        if (RUNNING.compareAndSet(false, true)) {
            this.fetchGroupConfig(ConfigGroupEnum.values());
            int threadSize = this.serverList.size();
            this.executor = new ThreadPoolExecutor(threadSize, threadSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ShenyuThreadFactory.create((String)"http-long-polling", (boolean)true));
            this.serverList.forEach(server -> this.executor.execute(new HttpLongPollingTask((String)server)));
        } else {
            LOG.info("shenyu http long polling was started, executor=[{}]", (Object)this.executor);
        }
    }

    private void fetchGroupConfig(ConfigGroupEnum ... groups) throws ShenyuException {
        for (int index = 0; index < this.serverList.size(); ++index) {
            String server = this.serverList.get(index);
            try {
                this.doFetchGroupConfig(server, groups);
                break;
            }
            catch (ShenyuException e) {
                if (index >= this.serverList.size() - 1) {
                    throw e;
                }
                LOG.warn("fetch config fail, try another one: {}", (Object)this.serverList.get(index + 1));
                continue;
            }
        }
    }

    private void doFetchGroupConfig(String server, ConfigGroupEnum ... groups) {
        String json;
        StringBuilder params = new StringBuilder();
        for (ConfigGroupEnum groupKey : groups) {
            params.append("groupKeys").append("=").append(groupKey.name()).append("&");
        }
        params.append("namespaceId").append("=").append(this.shenyuConfig.getNamespace());
        String url = server + "/configs/fetch?" + StringUtils.removeEnd((String)params.toString(), (String)"&");
        LOG.info("request configs: [{}]", (Object)url);
        Request request = new Request.Builder().url(url).addHeader("X-Access-Token", this.accessTokenManager.getAccessToken()).get().build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String message = String.format("fetch config fail from server[%s], http status code[%s]", url, response.code());
                LOG.warn(message);
                throw new ShenyuException(message);
            }
            ResponseBody responseBody = response.body();
            Assert.notNull((Object)responseBody, (String)"Resolve response responseBody failed.");
            json = responseBody.string();
        }
        catch (IOException e) {
            String message = String.format("fetch config fail from server[%s], %s", url, e.getMessage());
            LOG.warn(message);
            throw new ShenyuException(message, (Throwable)e);
        }
        boolean updated = this.updateCacheWithJson(json);
        if (updated) {
            LOG.debug("get latest configs: [{}]", (Object)json);
            return;
        }
        LOG.info("The config of the server[{}] has not been updated or is out of date. Wait for listening for changes again.", (Object)server);
        ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)5);
    }

    private boolean updateCacheWithJson(String json) {
        JsonObject jsonObject = (JsonObject)GsonUtils.getGson().fromJson(json, JsonObject.class);
        return this.factory.executor(jsonObject.getAsJsonObject("data"));
    }

    private void doLongPolling(String server) {
        JsonArray groupJson;
        LinkedMultiValueMap params = new LinkedMultiValueMap(8);
        for (ConfigGroupEnum group : ConfigGroupEnum.values()) {
            ConfigData<?> cacheConfig = this.factory.cacheConfigData(group);
            if (cacheConfig == null) continue;
            String value = String.join((CharSequence)",", cacheConfig.getMd5(), String.valueOf(cacheConfig.getLastModifyTime()));
            params.put((Object)group.name(), (Object)Lists.newArrayList((Object[])new String[]{value}));
        }
        params.put((Object)"namespaceId", (Object)Lists.newArrayList((Object[])new String[]{this.shenyuConfig.getNamespace()}));
        LOG.debug("listener params: [{}]", (Object)params);
        Headers headers = new Headers.Builder().add("X-Access-Token", this.accessTokenManager.getAccessToken()).add("Content-Type", "application/x-www-form-urlencoded").build();
        String listenerUrl = server + "/configs/listener";
        String uri = UriComponentsBuilder.fromHttpUrl((String)listenerUrl).queryParams((MultiValueMap)params).build(true).toUriString();
        Request request = new Request.Builder().url(uri).headers(headers).post(RequestBody.create((String)"", null)).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String message = String.format("listener configs fail, server:[%s], http status code[%s]", server, response.code());
                throw new ShenyuException(message);
            }
            ResponseBody responseBody = response.body();
            Assert.notNull((Object)responseBody, (String)"Resolve response body failed.");
            String json = responseBody.string();
            LOG.info("listener result: [{}]", (Object)json);
            JsonObject responseFromServer = (JsonObject)GsonUtils.getGson().fromJson(json, JsonObject.class);
            JsonElement element = responseFromServer.get("data");
            if (element.isJsonNull()) {
                return;
            }
            groupJson = responseFromServer.getAsJsonArray("data");
        }
        catch (IOException e) {
            String message = String.format("listener configs fail, server:[%s], %s", server, e.getMessage());
            throw new ShenyuException(message, (Throwable)e);
        }
        if (Objects.nonNull(groupJson) && !groupJson.isEmpty()) {
            Object[] changedGroups = (ConfigGroupEnum[])GsonUtils.getGson().fromJson((JsonElement)groupJson, ConfigGroupEnum[].class);
            LOG.info("Group config changed: {}", (Object)Arrays.toString(changedGroups));
            this.doFetchGroupConfig(server, (ConfigGroupEnum[])changedGroups);
        }
    }

    public void close() {
        RUNNING.set(false);
        if (Objects.nonNull(this.executor)) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    class HttpLongPollingTask
    implements Runnable {
        private final String server;

        HttpLongPollingTask(String server) {
            this.server = server;
        }

        @Override
        public void run() {
            while (RUNNING.get()) {
                int retryTimes = 10;
                for (int time = 1; time <= retryTimes; ++time) {
                    try {
                        HttpSyncDataService.this.doLongPolling(this.server);
                        continue;
                    }
                    catch (Exception e) {
                        if (time < retryTimes) {
                            LOG.warn("Long polling failed, tried {} times, {} times left, will be suspended for a while! {}", new Object[]{time, retryTimes - time, e.getMessage()});
                            ThreadUtils.sleep((TimeUnit)TimeUnit.SECONDS, (int)5);
                            continue;
                        }
                        LOG.error("Long polling failed, try again after 5 minutes!", (Throwable)e);
                        ThreadUtils.sleep((TimeUnit)TimeUnit.MINUTES, (int)5);
                    }
                }
            }
            LOG.warn("Stop http long polling.");
        }
    }
}

