/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.loadbalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.springcloud.cache.ServiceInstanceCache;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuSpringCloudServiceChooser {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuSpringCloudServiceChooser.class);

    public Upstream choose(String serviceId, String selectorId, String ip, String loadbalancer) {
        List<InstanceEntity> available = this.getServiceInstance(serviceId);
        if (CollectionUtils.isEmpty(available)) {
            LOG.info("choose return 1");
            return null;
        }
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)selectorId);
        if (!springCloudSelectorHandle.getGray()) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        List divideUpstreams = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(selectorId);
        if (CollectionUtils.isEmpty((Collection)divideUpstreams)) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        ArrayList<Upstream> choose = new ArrayList<Upstream>(available.size());
        for (InstanceEntity serviceInstance : available) {
            divideUpstreams.stream().filter(Upstream::isStatus).filter(upstream -> Objects.equals(upstream.getUrl(), serviceInstance.getUri().getRawAuthority())).findFirst().ifPresent(choose::add);
        }
        if (CollectionUtils.isEmpty(choose)) {
            return this.doSelect(serviceId, ip, loadbalancer);
        }
        return this.doSelect(choose, loadbalancer, ip);
    }

    private Upstream doSelect(String serviceId, String ip, String loadbalancer) {
        List<Upstream> choose = this.buildUpstream(serviceId);
        return this.doSelect(choose, loadbalancer, ip);
    }

    private Upstream doSelect(List<Upstream> upstreamList, String loadbalancer, String ip) {
        return LoadBalancerFactory.selector(upstreamList, (String)loadbalancer, (String)ip);
    }

    private List<InstanceEntity> getServiceInstance(String serviceId) {
        if (CollectionUtils.isNotEmpty(ServiceInstanceCache.getServiceInstance(serviceId))) {
            return ServiceInstanceCache.getServiceInstance(serviceId);
        }
        List instances = null;
        if (SpringCloudPluginDataHandler.getRepository() != null) {
            instances = SpringCloudPluginDataHandler.getRepository().selectInstances(serviceId);
        }
        List<InstanceEntity> instanceEntities = Optional.ofNullable(instances).orElse(Collections.emptyList());
        LOG.info("ShenyuSpringCloudServiceChooser selectInstance size: {}", (Object)instanceEntities.size());
        return instanceEntities;
    }

    private List<Upstream> buildUpstream(String serviceId) {
        List<InstanceEntity> serviceInstanceList = this.getServiceInstance(serviceId);
        if (CollectionUtils.isEmpty(serviceInstanceList)) {
            return Collections.emptyList();
        }
        return serviceInstanceList.stream().map(serviceInstance -> ShenyuSpringCloudServiceChooser.buildDefaultSpringCloudUpstream(serviceInstance.getUri().getRawAuthority(), serviceInstance.getUri().getScheme() + "://")).distinct().collect(Collectors.toList());
    }

    private static Upstream buildDefaultSpringCloudUpstream(String upstreamUrl, String protocol) {
        return Upstream.builder().url(upstreamUrl).protocol(protocol).weight(50).warmup(600000).timestamp(0L).build();
    }
}

