/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.cache;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.registry.api.entity.InstanceEntity;

public class ServiceInstanceCache {
    private static final Map<String, List<InstanceEntity>> SERVICE_INSTANCE_MAP = Maps.newConcurrentMap();

    public static void cacheServiceInstance(String serviceId, List<InstanceEntity> serviceInstances) {
        if (StringUtils.isNotBlank((CharSequence)serviceId)) {
            SERVICE_INSTANCE_MAP.put(serviceId, Optional.ofNullable(serviceInstances).orElse(Collections.emptyList()));
        }
    }

    public static List<InstanceEntity> getServiceInstance(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            return Collections.emptyList();
        }
        return SERVICE_INSTANCE_MAP.get(serviceId);
    }

    public static void removeServiceInstance(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            return;
        }
        SERVICE_INSTANCE_MAP.remove(serviceId);
    }
}

