/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.kubernetes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.registry.kubernetes.KubernetesConfig;
import org.apache.shenyu.registry.kubernetes.KubernetesInstance;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class KubernetesClient {
    private RestTemplate rest;
    private KubernetesConfig kubernetesConfig;

    public KubernetesClient(KubernetesConfig kubernetesConfig) {
        this.kubernetesConfig = kubernetesConfig;
        this.rest = new RestTemplate();
    }

    public List<KubernetesInstance> selectInstances(String serviceId) {
        List<KubernetesInstance> response = Collections.emptyList();
        KubernetesInstance[] responseBody = (KubernetesInstance[])this.rest.getForEntity(this.kubernetesConfig.getDiscoveryServerUrl() + "/apps/" + serviceId, KubernetesInstance[].class, new Object[0]).getBody();
        if (responseBody != null && responseBody.length > 0) {
            response = Arrays.stream(responseBody).filter(this::matchNamespaces).collect(Collectors.toList());
        }
        return response;
    }

    private boolean matchNamespaces(KubernetesInstance kubernetesInstance) {
        return CollectionUtils.isEmpty(this.kubernetesConfig.getNamespaces()) ? true : this.kubernetesConfig.getNamespaces().contains(kubernetesInstance.getNamespace());
    }
}

