/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.extractor;

import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.sign.api.SignParameters;
import org.apache.shenyu.plugin.sign.extractor.SignParameterExtractor;
import org.springframework.http.HttpRequest;

public class VersionTwoExtractor
implements SignParameterExtractor {
    @Override
    public SignParameters extract(HttpRequest httpRequest) {
        String token = Optional.ofNullable(httpRequest.getHeaders().getFirst("ShenYu-Authorization")).orElseGet(() -> this.getDefaultToken(httpRequest));
        if (StringUtils.isEmpty((CharSequence)token) || !token.contains(".")) {
            return new SignParameters();
        }
        String[] tokenArray = StringUtils.split((String)token, (char)'.');
        String parameters = tokenArray[0];
        String signature = tokenArray[1];
        Map headerMap = JsonUtils.jsonToMap((String)new String(Base64.getDecoder().decode(parameters)));
        SignParameters signParameters = new SignParameters("2.0.0", (String)headerMap.get("appKey"), (String)headerMap.get("timestamp"), signature, httpRequest.getURI(), (String)headerMap.get("alg"));
        signParameters.setParameters(parameters);
        return signParameters;
    }

    private String getDefaultToken(HttpRequest httpRequest) {
        return httpRequest.getHeaders().getFirst("Authorization");
    }
}

