/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.eureka.Version;
import jakarta.annotation.Nullable;
import java.util.Arrays;

public class Key {
    private final String entityName;
    private final String[] regions;
    private final KeyType requestType;
    private final Version requestVersion;
    private final String hashKey;
    private final EntityType entityType;
    private final EurekaAccept eurekaAccept;

    public Key(EntityType entityType, String entityName, KeyType type, Version v, EurekaAccept eurekaAccept) {
        this(entityType, entityName, type, v, eurekaAccept, null);
    }

    public Key(EntityType entityType, String entityName, KeyType type, Version v, EurekaAccept eurekaAccept, @Nullable String[] regions) {
        this.regions = regions;
        this.entityType = entityType;
        this.entityName = entityName;
        this.requestType = type;
        this.requestVersion = v;
        this.eurekaAccept = eurekaAccept;
        this.hashKey = (Object)((Object)this.entityType) + this.entityName + (null != this.regions ? Arrays.toString(this.regions) : "") + this.requestType.name() + this.requestVersion.name() + this.eurekaAccept.name();
    }

    public String getName() {
        return this.entityName;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public KeyType getType() {
        return this.requestType;
    }

    public Version getVersion() {
        return this.requestVersion;
    }

    public EurekaAccept getEurekaAccept() {
        return this.eurekaAccept;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public boolean hasRegions() {
        return null != this.regions && this.regions.length != 0;
    }

    public String[] getRegions() {
        return this.regions;
    }

    public Key cloneWithoutRegions() {
        return new Key(this.entityType, this.entityName, this.requestType, this.requestVersion, this.eurekaAccept);
    }

    public int hashCode() {
        String hashKey = this.getHashKey();
        return hashKey.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Key) {
            return this.getHashKey().equals(((Key)other).getHashKey());
        }
        return false;
    }

    public String toStringCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append("{name=").append(this.entityName).append(", type=").append((Object)this.entityType).append(", format=").append((Object)this.requestType);
        if (this.regions != null) {
            sb.append(", regions=").append(Arrays.toString(this.regions));
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum EntityType {
        Application,
        VIP,
        SVIP;

    }

    public static enum KeyType {
        JSON,
        XML;

    }
}

