/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.zookeeper;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.path.InstancePathConstants;
import org.apache.shenyu.registry.zookeeper.ZookeeperClient;
import org.apache.shenyu.registry.zookeeper.ZookeeperConfig;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperInstanceRegisterRepository.class);
    private ZookeeperClient client;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();
    private final Map<String, List<InstanceEntity>> watcherInstanceRegisterMap = new HashMap<String, List<InstanceEntity>>();

    public void init(RegisterConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        LOGGER.info("zookeeper init");
        this.client = new ZookeeperClient(zkConfig);
        this.client.getClient().getConnectionStateListenable().addListener((c, newState) -> {
            if (newState == ConnectionState.RECONNECTED) {
                this.nodeDataMap.forEach((k, v) -> {
                    if (!this.client.isExist((String)k)) {
                        this.client.createOrUpdate((String)k, (String)v, CreateMode.EPHEMERAL);
                        LOGGER.info("zookeeper client register instance success: {}", v);
                    }
                });
            }
        });
        this.client.start();
    }

    public void persistInstance(InstanceEntity instance) {
        String uriNodeName = this.buildInstanceNodeName(instance);
        String instancePath = InstancePathConstants.buildInstanceParentPath((String)instance.getAppName());
        if (!this.client.isExist(instancePath)) {
            this.client.createOrUpdate(instancePath, "", CreateMode.PERSISTENT);
        }
        String realNode = InstancePathConstants.buildRealNode((String)instancePath, (String)uriNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.nodeDataMap.put(realNode, nodeData);
        this.client.createOrUpdate(realNode, nodeData, CreateMode.EPHEMERAL);
    }

    public List<InstanceEntity> selectInstances(final String selectKey) {
        String watchKey = InstancePathConstants.buildInstanceParentPath((String)selectKey);
        final Function<List, List> getInstanceRegisterFun = childrenList -> childrenList.stream().map(childPath -> {
            String instanceRegisterJsonStr = this.client.get(InstancePathConstants.buildRealNode((String)watchKey, (String)childPath));
            InstanceEntity instanceEntity = (InstanceEntity)GsonUtils.getInstance().fromJson(instanceRegisterJsonStr, InstanceEntity.class);
            instanceEntity.setUri(this.getURI(instanceRegisterJsonStr, instanceEntity.getPort(), instanceEntity.getHost()));
            return instanceEntity;
        }).collect(Collectors.toList());
        if (this.watcherInstanceRegisterMap.containsKey(selectKey)) {
            return this.watcherInstanceRegisterMap.get(selectKey);
        }
        List<String> childrenPathList = this.client.subscribeChildrenChanges(watchKey, new CuratorWatcher(){

            public void process(WatchedEvent event) {
                try {
                    List childrenList;
                    String path = Objects.isNull(event.getPath()) ? selectKey : event.getPath();
                    List<Object> list = childrenList = StringUtils.isNotBlank((CharSequence)path) ? ZookeeperInstanceRegisterRepository.this.client.subscribeChildrenChanges(path, this) : Collections.emptyList();
                    if (!childrenList.isEmpty()) {
                        ZookeeperInstanceRegisterRepository.this.watcherInstanceRegisterMap.put(selectKey, (List)getInstanceRegisterFun.apply(childrenList));
                    }
                }
                catch (Exception e) {
                    ZookeeperInstanceRegisterRepository.this.watcherInstanceRegisterMap.remove(selectKey);
                    LOGGER.error("zookeeper client subscribeChildrenChanges watch interrupt error:", (Throwable)e);
                }
            }
        });
        List instanceEntities = getInstanceRegisterFun.apply(childrenPathList);
        this.watcherInstanceRegisterMap.put(selectKey, instanceEntities);
        return instanceEntities;
    }

    private URI getURI(String instanceRegisterJsonStr, int port, String host) {
        String scheme = instanceRegisterJsonStr.contains("https") || instanceRegisterJsonStr.contains("HTTPS") ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, host, port);
        return URI.create(uri);
    }

    public void close() {
        this.client.close();
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }
}

