/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sentinel;

import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.SentinelHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.fallback.FallbackHandler;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.sentinel.handler.SentinelRuleHandle;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SentinelPlugin
extends AbstractShenyuPlugin {
    private final FallbackHandler fallbackHandler;

    public SentinelPlugin(FallbackHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        String resourceName = CacheKeyUtils.INST.getKey(rule);
        SentinelHandle sentinelHandle = (SentinelHandle)SentinelRuleHandle.CACHED_HANDLE.get().obtainHandle((Object)resourceName);
        sentinelHandle.checkData();
        exchange.getAttributes().put("WATCHER_HTTP_STATUS", status -> {
            if (status == null || !status.is2xxSuccessful()) {
                throw new SentinelFallbackException(status == null ? HttpStatus.INTERNAL_SERVER_ERROR : status);
            }
        });
        return chain.execute(exchange).transform((Function)new SentinelReactorTransformer(resourceName)).onErrorResume(throwable -> this.fallbackHandler.fallback(exchange, UriUtils.createUri((String)sentinelHandle.getFallbackUri()), throwable)).doFinally(monoV -> {
            Consumer consumer = (Consumer)exchange.getAttribute("metricsSentinel");
            Optional.ofNullable(consumer).ifPresent(c -> c.accept(exchange.getResponse().getStatusCode()));
        });
    }

    public String named() {
        return PluginEnum.SENTINEL.getName();
    }

    public int getOrder() {
        return PluginEnum.SENTINEL.getCode();
    }

    public static class SentinelFallbackException
    extends HttpStatusCodeException {
        public SentinelFallbackException(HttpStatus statusCode) {
            super((HttpStatusCode)statusCode);
        }
    }
}

