/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.body;

import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResult;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.base.utils.MediaTypeUtils;
import org.apache.shenyu.plugin.logging.common.body.BodyWriter;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectUtils;
import org.apache.shenyu.plugin.logging.desensitize.api.matcher.KeyWordMatch;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class LoggingServerHttpResponse<L extends ShenyuRequestLog>
extends ServerHttpResponseDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingServerHttpResponse.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final L logInfo;
    private ServerWebExchange exchange;
    private final LogCollector<L> logCollector;
    private final boolean desensitized;
    private final String dataDesensitizeAlg;
    private final KeyWordMatch keyWordMatch;

    public LoggingServerHttpResponse(ServerHttpResponse delegate, L logInfo, LogCollector<L> logCollector, boolean desensitized, Set<String> keyWordSet, String dataDesensitizeAlg) {
        super(delegate);
        this.logInfo = logInfo;
        this.logCollector = logCollector;
        this.desensitized = desensitized;
        this.dataDesensitizeAlg = dataDesensitizeAlg;
        this.keyWordMatch = new KeyWordMatch(keyWordSet);
    }

    public void setExchange(ServerWebExchange exchange) {
        this.exchange = exchange;
    }

    @NonNull
    public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
        return super.writeWith(this.appendResponse(body));
    }

    @NonNull
    private Flux<? extends DataBuffer> appendResponse(Publisher<? extends DataBuffer> body) {
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        if (this.getStatusCode() != null) {
            ((ShenyuRequestLog)this.logInfo).setStatus(this.getStatusCode().value());
        }
        ((ShenyuRequestLog)this.logInfo).setResponseHeader(LogCollectUtils.getHeaders(this.getHeaders()));
        ((ShenyuRequestLog)this.logInfo).setTraceId(this.getTraceId());
        MediaType mediaType = this.exchange.getResponse().getHeaders().getContentType();
        if (MediaTypeUtils.isByteType((MediaType)mediaType)) {
            return Flux.from(body).doFinally(signal -> this.logResponse(shenyuContext, null));
        }
        BodyWriter writer = new BodyWriter();
        return Flux.from(body).doOnNext(buffer -> {
            if (LogCollectUtils.isNotBinaryType(this.getHeaders())) {
                try (DataBuffer.ByteBufferIterator bufferIterator = buffer.readableByteBuffers();){
                    bufferIterator.forEachRemaining(byteBuffer -> writer.write(byteBuffer.asReadOnlyBuffer()));
                }
            }
        }).doFinally(signal -> this.logResponse(shenyuContext, writer));
    }

    private void logResponse(ShenyuContext shenyuContext, BodyWriter writer) {
        if (StringUtils.isNotBlank((CharSequence)this.getHeaders().getFirst("Content-Length"))) {
            String size = (String)StringUtils.defaultIfEmpty((CharSequence)this.getHeaders().getFirst("Content-Length"), (CharSequence)"0");
            ((ShenyuRequestLog)this.logInfo).setResponseContentLength(Integer.parseInt(size));
        } else if (Objects.nonNull(writer)) {
            ((ShenyuRequestLog)this.logInfo).setResponseContentLength(writer.size());
        }
        ((ShenyuRequestLog)this.logInfo).setTimeLocal(shenyuContext.getStartDateTime().format(DATE_TIME_FORMATTER));
        ((ShenyuRequestLog)this.logInfo).setModule(shenyuContext.getModule());
        long costTime = DateUtils.acquireMillisBetween((LocalDateTime)shenyuContext.getStartDateTime(), (LocalDateTime)LocalDateTime.now());
        ((ShenyuRequestLog)this.logInfo).setUpstreamResponseTime(costTime);
        ((ShenyuRequestLog)this.logInfo).setMethod(shenyuContext.getMethod());
        ((ShenyuRequestLog)this.logInfo).setRpcType(shenyuContext.getRpcType());
        if (StringUtils.isNotBlank((CharSequence)shenyuContext.getRpcType())) {
            ((ShenyuRequestLog)this.logInfo).setUpstreamIp(this.getUpstreamIp());
        }
        if (Objects.nonNull(writer)) {
            int size = writer.size();
            String body = writer.output();
            if (size > 0 && !LogCollectConfigUtils.isResponseBodyTooLarge(size)) {
                ((ShenyuRequestLog)this.logInfo).setResponseBody(body);
            }
        } else {
            ((ShenyuRequestLog)this.logInfo).setResponseBody("[bytes]");
        }
        if (Objects.nonNull(this.logCollector)) {
            if (this.desensitized) {
                this.logCollector.desensitize(this.logInfo, this.keyWordMatch, this.dataDesensitizeAlg);
            }
            this.logCollector.collect(this.logInfo);
        }
    }

    private String getUpstreamIp() {
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        if (RpcTypeEnum.HTTP.getName().equals(shenyuContext.getRpcType())) {
            URI uri = (URI)this.exchange.getAttribute("httpUri");
            if (Objects.nonNull(uri)) {
                return uri.getHost();
            }
            return this.getUpstreamIpFromHttpDomain();
        }
        String domain = (String)this.exchange.getAttributes().get("httpDomain");
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            return this.getUpstreamIpFromHttpDomain();
        }
        return "";
    }

    private String getTraceId() {
        return (String)this.exchange.getAttributes().get("shenyu-agent-trace-id");
    }

    public void logError(Throwable throwable) {
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        if (throwable instanceof ResponseStatusException) {
            httpStatus = ((ResponseStatusException)throwable).getStatusCode();
        }
        ((ShenyuRequestLog)this.logInfo).setStatus(httpStatus.value());
        ((ShenyuRequestLog)this.logInfo).setTraceId(this.getTraceId());
        Object result = ShenyuResultWrap.error((ServerWebExchange)this.exchange, (int)httpStatus.value(), (String)httpStatus.getReasonPhrase(), (Object)throwable.getMessage());
        ShenyuResult shenyuResult = ShenyuResultWrap.shenyuResult();
        Object resultData = shenyuResult.format(this.exchange, result);
        Object responseData = shenyuResult.result(this.exchange, resultData);
        assert (null != responseData);
        byte[] bytes = responseData instanceof byte[] ? (byte[])responseData : responseData.toString().getBytes(StandardCharsets.UTF_8);
        ((ShenyuRequestLog)this.logInfo).setResponseContentLength(bytes.length);
        ShenyuContext shenyuContext = (ShenyuContext)this.exchange.getAttribute("context");
        assert (shenyuContext != null);
        ((ShenyuRequestLog)this.logInfo).setTimeLocal(shenyuContext.getStartDateTime().format(DATE_TIME_FORMATTER));
        ((ShenyuRequestLog)this.logInfo).setModule(shenyuContext.getModule());
        long costTime = DateUtils.acquireMillisBetween((LocalDateTime)shenyuContext.getStartDateTime(), (LocalDateTime)LocalDateTime.now());
        ((ShenyuRequestLog)this.logInfo).setUpstreamResponseTime(costTime);
        ((ShenyuRequestLog)this.logInfo).setResponseHeader(LogCollectUtils.getHeaders(this.exchange.getResponse().getHeaders()));
        ((ShenyuRequestLog)this.logInfo).setRpcType(shenyuContext.getRpcType());
        ((ShenyuRequestLog)this.logInfo).setMethod(shenyuContext.getMethod());
        if (StringUtils.isNotBlank((CharSequence)shenyuContext.getRpcType())) {
            ((ShenyuRequestLog)this.logInfo).setUpstreamIp(this.getUpstreamIp());
        }
        int size = bytes.length;
        String body = new String(bytes, StandardCharsets.UTF_8);
        if (size > 0 && !LogCollectConfigUtils.isResponseBodyTooLarge(size)) {
            ((ShenyuRequestLog)this.logInfo).setResponseBody(body);
        }
        if (Objects.nonNull(this.logCollector)) {
            if (this.desensitized) {
                this.logCollector.desensitize(this.logInfo, this.keyWordMatch, this.dataDesensitizeAlg);
            }
            this.logCollector.collect(this.logInfo);
        }
    }

    private String getUpstreamIpFromHttpDomain() {
        String domain = (String)this.exchange.getAttributes().get("httpDomain");
        try {
            if (StringUtils.isNotBlank((CharSequence)domain)) {
                URL url = new URL(domain);
                return url.getHost();
            }
        }
        catch (Exception e) {
            LOG.error("get upstream ip error");
        }
        return "";
    }
}

