/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.polaris;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigFilePublishService;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import org.apache.shenyu.admin.config.properties.PolarisProperties;
import org.apache.shenyu.admin.listener.AbstractNodeDataChangedListener;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisDataChangedListener
extends AbstractNodeDataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisDataChangedListener.class);
    private final PolarisProperties polarisProperties;
    private final ConfigFileService configFileService;
    private final ConfigFilePublishService configFilePublishService;

    public PolarisDataChangedListener(PolarisProperties polarisProperties, ConfigFileService configFileService, ConfigFilePublishService configFilePublishService) {
        super(new AbstractNodeDataChangedListener.ChangeData("plugin", "selector", "rule", "auth", "meta", "proxy.selector", "discovery"));
        this.polarisProperties = polarisProperties;
        this.configFileService = configFileService;
        this.configFilePublishService = configFilePublishService;
    }

    public void doPublishConfig(String dataId, Object data) {
        try {
            DefaultConfigFileMetadata metadata = new DefaultConfigFileMetadata(this.polarisProperties.getNamespace(), this.polarisProperties.getFileGroup(), dataId);
            if (this.isReleased(metadata)) {
                this.configFilePublishService.updateConfigFile((ConfigFileMetadata)metadata, data == null ? "" : GsonUtils.getInstance().toJson(data));
            } else {
                this.configFilePublishService.createConfigFile((ConfigFileMetadata)metadata, GsonUtils.getInstance().toJson(data));
            }
            this.configFilePublishService.releaseConfigFile((ConfigFileMetadata)metadata);
        }
        catch (PolarisException e) {
            LOG.error("Polaris Publish data to polaris error.", (Throwable)e);
        }
    }

    public void doDelConfig(String dataId) {
        this.doPublishConfig(dataId, null);
    }

    public String getConfig(String dataId) {
        try {
            ConfigFile configFile = this.configFileService.getConfigFile(this.polarisProperties.getNamespace(), this.polarisProperties.getFileGroup(), dataId);
            return configFile.hasContent() ? configFile.getContent() : null;
        }
        catch (PolarisException e) {
            LOG.error("Polaris Get data from polaris error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private boolean isReleased(DefaultConfigFileMetadata metadata) {
        try {
            return this.configFileService.getConfigFile((ConfigFileMetadata)metadata).getContent() != null;
        }
        catch (PolarisException e) {
            LOG.error("Polaris Get data from polaris error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

