/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtil.class);

    private ZipUtil() {
    }

    public static byte[] zip(List<ZipItem> source) {
        byte[] result = null;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream(byteOut);){
            for (ZipItem item : source) {
                zipOut.putNextEntry(new ZipEntry(item.getItemName()));
                zipOut.write(item.getItemData().getBytes(StandardCharsets.UTF_8));
            }
            zipOut.flush();
            zipOut.finish();
            result = byteOut.toByteArray();
        }
        catch (IOException e) {
            LOG.error("an error occurred while compressing data.", (Throwable)e);
        }
        return result;
    }

    public static UnZipResult unzip(byte[] source) {
        ArrayList itemList = Lists.newArrayList();
        try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(source));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int offset;
                    byte[] buffer = new byte[1024];
                    while ((offset = zipIn.read(buffer)) != -1) {
                        out.write(buffer, 0, offset);
                    }
                    String entryName = entry.getName();
                    itemList.add(new ZipItem(entryName, out.toString(StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    LOG.error("unzip error", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.error("unzip error", (Throwable)e);
        }
        return new UnZipResult(itemList);
    }

    public static class ZipItem {
        private final String itemName;
        private final String itemData;

        public ZipItem(String itemName, String itemData) {
            this.itemName = itemName;
            this.itemData = itemData;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getItemData() {
            return this.itemData;
        }
    }

    public static class UnZipResult {
        private final List<ZipItem> zipItemList;

        public UnZipResult(List<ZipItem> zipItemList) {
            this.zipItemList = zipItemList;
        }

        public List<ZipItem> getZipItemList() {
            return this.zipItemList;
        }
    }
}

