/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;

public final class SelectorUtil {
    private SelectorUtil() {
    }

    public static List<DivideUpstream> buildDivideUpstream(SelectorDO selectorDO, String pluginName) {
        if (PluginEnum.SPRING_CLOUD.getName().equals(pluginName) && Objects.nonNull(selectorDO.getHandle())) {
            return ((SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(selectorDO.getHandle(), SpringCloudSelectorHandle.class)).getDivideUpstreams();
        }
        if (PluginEnum.DIVIDE.getName().equals(pluginName) && StringUtils.isNotBlank((CharSequence)selectorDO.getHandle())) {
            return GsonUtils.getInstance().fromList(selectorDO.getHandle(), DivideUpstream.class);
        }
        return Collections.emptyList();
    }

    public static SelectorDTO buildSelectorDTO(String contextPath, String pluginId) {
        SelectorDTO selectorDTO = SelectorUtil.buildDefaultSelectorDTO(contextPath);
        selectorDTO.setPluginId(pluginId);
        selectorDTO.setSelectorConditions(SelectorUtil.buildDefaultSelectorConditionDTO(contextPath));
        return selectorDTO;
    }

    public static SelectorDTO buildDefaultSelectorDTO(String name) {
        return SelectorDTO.builder().name(name).type(SelectorTypeEnum.CUSTOM_FLOW.getCode()).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).continued(Boolean.TRUE).matchRestful(Boolean.FALSE).sort(1).build();
    }

    public static List<SelectorConditionDTO> buildDefaultSelectorConditionDTO(String contextPath) {
        SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
        selectorConditionDTO.setParamType(ParamTypeEnum.URI.getName());
        selectorConditionDTO.setParamName("/");
        selectorConditionDTO.setOperator(OperatorEnum.STARTS_WITH.getAlias());
        selectorConditionDTO.setParamValue(contextPath + "/");
        return Collections.singletonList(selectorConditionDTO);
    }
}

