/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.converter.SpringCloudSelectorHandleConverter;
import org.apache.shenyu.admin.service.register.AbstractContextPathRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.springframework.stereotype.Service;

@Service(value="springCloud")
public class ShenyuClientRegisterSpringCloudServiceImpl
extends AbstractContextPathRegisterService {
    @Resource
    private SpringCloudSelectorHandleConverter springCloudSelectorHandleConverter;

    @Override
    public String rpcType() {
        return RpcTypeEnum.SPRING_CLOUD.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return GsonUtils.getInstance().toJson((Object)SpringCloudSelectorHandle.builder().serviceId(metaDataDTO.getAppName()).build());
    }

    @Override
    protected String ruleHandler() {
        return new SpringCloudRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        MetaDataDO metaDataDO = metaDataService.findByPathAndNamespaceId(metaDataDTO.getPath(), metaDataDTO.getNamespaceId());
        metaDataService.saveOrUpdateMetaData(metaDataDO, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        SpringCloudSelectorHandle springCloudSelectorHandle;
        List existList;
        boolean isEventDeleted;
        List<DivideUpstream> addList = this.buildDivideUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        boolean bl = isEventDeleted = uriList.size() == 1 && EventType.DELETED.equals((Object)uriList.get(0).getEventType());
        if (isEventDeleted) {
            addList.get(0).setStatus(false);
        }
        if (CollectionUtils.isEmpty((Collection)(existList = (springCloudSelectorHandle = (SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(selectorDO.getHandle(), SpringCloudSelectorHandle.class)).getDivideUpstreams()))) {
            canAddList = addList;
        } else {
            List diffStatusList;
            List diffList = addList.stream().filter(upstream -> !existList.contains(upstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            if (CollectionUtils.isNotEmpty(diffStatusList = addList.stream().filter(upstream -> !upstream.isStatus() || existList.stream().anyMatch(e -> e.equals(upstream) && e.isStatus() != upstream.isStatus())).collect(Collectors.toList()))) {
                canAddList.addAll(diffStatusList);
            }
        }
        if (this.doSubmit(selectorDO.getId(), canAddList)) {
            return null;
        }
        springCloudSelectorHandle.setDivideUpstreams(CollectionUtils.isEmpty((Collection)existList) ? canAddList : existList);
        return GsonUtils.getInstance().toJson((Object)springCloudSelectorHandle);
    }

    private List<DivideUpstream> buildDivideUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDefaultDivideUpstream(dto.getHost(), dto.getPort(), dto.getNamespaceId())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }
}

