/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.model.bean.CustomCode;
import org.apache.shenyu.admin.model.bean.DocInfo;
import org.apache.shenyu.admin.model.bean.DocItem;
import org.apache.shenyu.admin.model.bean.DocModule;
import org.apache.shenyu.admin.model.bean.DocParameter;
import org.apache.shenyu.admin.service.manager.DocParser;
import org.apache.shenyu.common.utils.GsonUtils;

public class SwaggerDocParser
implements DocParser {
    @Override
    public DocInfo parseJson(JsonObject docRoot) {
        String basePath = docRoot.get("basePath").getAsString();
        String title = Optional.ofNullable(docRoot.getAsJsonObject("info")).map(jsonObject -> jsonObject.get("title").getAsString()).orElse(basePath);
        ArrayList<DocItem> docItems = new ArrayList<DocItem>();
        JsonObject paths = docRoot.getAsJsonObject("paths");
        if (Objects.isNull(paths)) {
            paths = new JsonObject();
        }
        Set pathNameSet = paths.keySet();
        for (String apiPath : pathNameSet) {
            JsonObject pathInfo = paths.getAsJsonObject(apiPath);
            Collection<String> httpMethodList = this.getHttpMethods(pathInfo);
            Optional<String> first = httpMethodList.stream().findFirst();
            if (!first.isPresent()) continue;
            String method = first.get();
            JsonObject docInfo = pathInfo.getAsJsonObject(method);
            docInfo.addProperty("real_req_path", apiPath);
            docInfo.addProperty("basePath", basePath);
            DocItem docItem = this.buildDocItem(docInfo, docRoot);
            if (Objects.isNull(docItem)) continue;
            if (docItem.isUploadRequest()) {
                docItem.setHttpMethodList(Sets.newHashSet((Object[])new String[]{"post"}));
            } else {
                docItem.setHttpMethodList(httpMethodList);
            }
            docItems.add(docItem);
        }
        docItems.sort(Comparator.comparing(DocItem::getApiOrder).thenComparing(DocItem::getName));
        List<DocModule> docModuleList = docItems.stream().collect(Collectors.groupingBy(DocItem::getModule)).entrySet().stream().map(entry -> {
            List docItemList = (List)entry.getValue();
            DocModule docModule = new DocModule();
            docModule.setModule((String)entry.getKey());
            docModule.setDocItems(docItemList);
            docModule.setOrder(this.getMuduleOrder(docItemList));
            return docModule;
        }).sorted(Comparator.comparing(DocModule::getOrder)).collect(Collectors.toList());
        DocInfo docInfo = new DocInfo();
        docInfo.setTitle(title);
        docInfo.setDocModuleList(docModuleList);
        return docInfo;
    }

    private int getMuduleOrder(List<DocItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Integer.MAX_VALUE;
        }
        ArrayList<DocItem> docItemList = new ArrayList<DocItem>(items);
        docItemList.sort(Comparator.comparing(DocItem::getModuleOrder));
        return ((DocItem)docItemList.get(0)).getModuleOrder();
    }

    protected Collection<String> getHttpMethods(JsonObject pathInfo) {
        Set httpMethodList = pathInfo.keySet();
        ArrayList<String> retList = new ArrayList<String>(httpMethodList);
        Collections.sort(retList);
        return retList;
    }

    protected DocItem buildDocItem(JsonObject docInfo, JsonObject docRoot) {
        Object apiName = docInfo.get("real_req_path").getAsString();
        String basePath = docInfo.get("basePath").getAsString();
        apiName = basePath + (String)apiName;
        DocItem docItem = new DocItem();
        docItem.setName((String)apiName);
        if (Objects.nonNull(docInfo.get("summary"))) {
            docItem.setSummary(docInfo.get("summary").getAsString());
        }
        if (Objects.nonNull(docInfo.get("description"))) {
            docItem.setDescription(docInfo.get("description").getAsString());
        }
        docItem.setConsumes((Collection)GsonUtils.getGson().fromJson((JsonElement)docInfo.getAsJsonArray("consumes"), new TypeToken<List<String>>(){}.getType()));
        docItem.setProduces((Collection)GsonUtils.getGson().fromJson((JsonElement)docInfo.getAsJsonArray("produces"), new TypeToken<List<String>>(){}.getType()));
        if (Objects.nonNull(docInfo.get("multiple"))) {
            docItem.setMultiple(true);
        }
        if (Objects.nonNull(docInfo.get("apiResponse"))) {
            docItem.setBizCodeList(GsonUtils.getInstance().fromList(docInfo.get("apiResponse").getAsString(), CustomCode.class));
        }
        if (Objects.nonNull(docInfo.get("module_order"))) {
            docItem.setModuleOrder(NumberUtils.toInt((String)docInfo.get("module_order").getAsString(), (int)0));
        }
        if (Objects.nonNull(docInfo.get("api_order"))) {
            docItem.setApiOrder(NumberUtils.toInt((String)docInfo.get("api_order").getAsString(), (int)0));
        }
        String moduleName = this.buildModuleName(docInfo, docRoot, basePath);
        docItem.setModule(moduleName);
        this.buildRequestParameterList(docItem, docInfo, docRoot);
        List<DocParameter> responseParameterList = this.buildResponseParameterList(docInfo, docRoot);
        docItem.setResponseParameters(responseParameterList);
        return docItem;
    }

    protected String buildModuleName(JsonObject docInfo, JsonObject docRoot, String basePath) {
        JsonArray tags = docInfo.getAsJsonArray("tags");
        if (Objects.nonNull(tags) && !tags.isEmpty()) {
            return tags.get(0).getAsString();
        }
        return Optional.ofNullable(docRoot.getAsJsonObject("info")).map(jsonObject -> jsonObject.get("title").getAsString()).orElse(basePath);
    }

    protected void buildRequestParameterList(DocItem docItem, JsonObject docInfo, JsonObject docRoot) {
        Optional<JsonArray> parametersOptional = Optional.ofNullable(docInfo.getAsJsonArray("parameters"));
        JsonArray parameters = parametersOptional.orElse(new JsonArray());
        ArrayList<DocParameter> docRequestParameterList = new ArrayList<DocParameter>();
        ArrayList<DocParameter> docHeaderParameterList = new ArrayList<DocParameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            JsonObject fieldJson = parameters.get(i).getAsJsonObject();
            JsonObject schema = fieldJson.getAsJsonObject("schema");
            if (Objects.nonNull(schema)) {
                RefInfo refInfo = this.getRefInfo(schema);
                if (!Objects.nonNull(refInfo)) continue;
                List<DocParameter> parameterList = this.buildDocParameters(refInfo.ref, docRoot, true);
                docRequestParameterList.addAll(parameterList);
                continue;
            }
            DocParameter docParameter2 = (DocParameter)GsonUtils.getInstance().fromJson((JsonElement)fieldJson, DocParameter.class);
            JsonElement inElement = fieldJson.get("in");
            if (Objects.nonNull(inElement) && "header".equals(inElement.getAsString())) {
                docHeaderParameterList.add(docParameter2);
                continue;
            }
            docRequestParameterList.add(docParameter2);
        }
        Map<String, List<DocParameter>> collect = docRequestParameterList.stream().filter(docParameter -> docParameter.getName().contains(".")).map(docParameter -> {
            String name = docParameter.getName();
            int index = name.indexOf(46);
            String module = name.substring(0, index);
            String newName = name.substring(index + 1);
            DocParameter ret = DocParameter.copy(docParameter);
            ret.setName(newName);
            ret.setModule(module);
            return ret;
        }).collect(Collectors.groupingBy(DocParameter::getModule));
        collect.forEach((key, value) -> {
            DocParameter moduleDoc = new DocParameter();
            moduleDoc.setName((String)key);
            moduleDoc.setType("object");
            moduleDoc.setRefs((List<DocParameter>)value);
            docRequestParameterList.add(moduleDoc);
        });
        List<DocParameter> requestParameterList = docRequestParameterList.stream().filter(docParameter -> !docParameter.getName().contains(".")).collect(Collectors.toList());
        docItem.setRequestParameters(requestParameterList);
        docItem.setRequestHeaders(docHeaderParameterList);
    }

    protected List<DocParameter> buildResponseParameterList(JsonObject docInfo, JsonObject docRoot) {
        RefInfo refInfo = this.getResponseRefInfo(docInfo);
        List<DocParameter> respParameterList = Collections.emptyList();
        if (Objects.nonNull(refInfo)) {
            String responseRef = refInfo.ref;
            respParameterList = this.buildDocParameters(responseRef, docRoot, true);
            if (refInfo.isArray) {
                DocParameter docParameter = new DocParameter();
                docParameter.setName("items");
                docParameter.setType("array");
                docParameter.setRefs(respParameterList);
                respParameterList = Collections.singletonList(docParameter);
            }
        }
        return respParameterList;
    }

    protected List<DocParameter> buildDocParameters(String ref, JsonObject docRoot, boolean doSubRef) {
        JsonObject responseObject = docRoot.getAsJsonObject("components").getAsJsonObject("schemas").getAsJsonObject(ref);
        JsonObject extProperties = responseObject.getAsJsonObject("properties");
        JsonArray requiredProperties = responseObject.getAsJsonArray("required");
        List<String> requiredFieldList = this.jsonArrayToStringList(requiredProperties);
        JsonObject properties = responseObject.getAsJsonObject("properties");
        ArrayList<DocParameter> docParameterList = new ArrayList<DocParameter>();
        if (Objects.isNull(properties)) {
            return docParameterList;
        }
        Set fieldNames = properties.keySet();
        for (String fieldName : fieldNames) {
            JsonObject prop;
            JsonObject fieldInfo = properties.getAsJsonObject(fieldName);
            DocParameter docParameter = (DocParameter)GsonUtils.getInstance().fromJson((JsonElement)fieldInfo, DocParameter.class);
            docParameter.setName(fieldName);
            docParameter.setRequired(requiredFieldList.contains(fieldName));
            if (Objects.nonNull(extProperties) && Objects.nonNull(prop = extProperties.getAsJsonObject(fieldName))) {
                docParameter.setMaxLength(Objects.isNull(prop.get("maxLength")) ? "-" : prop.get("maxLength").getAsString());
                if (Objects.nonNull(prop.get("required"))) {
                    docParameter.setRequired(Boolean.parseBoolean(prop.get("required").getAsString()));
                }
            }
            docParameterList.add(docParameter);
            RefInfo refInfo = this.getRefInfo(fieldInfo);
            if (!Objects.nonNull(refInfo) || !doSubRef) continue;
            String subRef = refInfo.ref;
            boolean nextDoRef = !Objects.equals(ref, subRef);
            List<DocParameter> refs = this.buildDocParameters(subRef, docRoot, nextDoRef);
            docParameter.setRefs(refs);
        }
        return docParameterList;
    }

    private List<String> jsonArrayToStringList(JsonArray jsonArray) {
        if (Objects.isNull(jsonArray)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(jsonArray.size());
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement.isJsonNull()) continue;
            String objStr = jsonElement.getAsString();
            list.add(objStr);
        }
        return list;
    }

    protected RefInfo getResponseRefInfo(JsonObject docInfo) {
        return Optional.ofNullable(docInfo.getAsJsonObject("responses")).flatMap(jsonObject -> Optional.ofNullable(jsonObject.getAsJsonObject("200"))).flatMap(jsonObject -> Optional.ofNullable(jsonObject.getAsJsonObject("schema"))).map(this::getRefInfo).orElse(null);
    }

    private RefInfo getRefInfo(JsonObject jsonObject) {
        boolean isArray = Objects.nonNull(jsonObject.get("type")) && "array".equals(jsonObject.get("type").getAsString());
        JsonElement refElement = isArray ? jsonObject.getAsJsonObject("items").get("$ref") : jsonObject.get("$ref");
        if (Objects.isNull(refElement)) {
            return null;
        }
        String ref = refElement.getAsString();
        int index = ref.lastIndexOf("/");
        if (index > -1) {
            ref = ref.substring(index + 1);
        }
        RefInfo refInfo = new RefInfo();
        refInfo.isArray = isArray;
        refInfo.ref = ref;
        return refInfo;
    }

    private static class RefInfo {
        private boolean isArray;
        private String ref;

        private RefInfo() {
        }
    }
}

