/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.discovery.DiscoveryStreamUpdatedEvent;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverterFactor;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.ZombieUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.common.utils.UpstreamCheckUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UpstreamCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(UpstreamCheckService.class);
    private static final Map<String, List<CommonUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private static final Set<Integer> PENDING_SYNC = Sets.newConcurrentHashSet();
    private static final Set<ZombieUpstream> ZOMBIE_SET = Sets.newConcurrentHashSet();
    private static final String REGISTER_TYPE_HTTP = "http";
    private static int zombieRemovalTimes;
    private final int zombieCheckTimes;
    private final int scheduledTime;
    private final String registerType;
    private final boolean checked;
    private final Integer scheduledThreads;
    private final SelectorMapper selectorMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final PluginMapper pluginMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final SelectorHandleConverterFactor converterFactor;
    private final DiscoveryUpstreamService discoveryUpstreamService;
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledThreadPoolExecutor invokeExecutor;
    private final List<CompletableFuture<Void>> futures = Lists.newArrayList();

    public UpstreamCheckService(SelectorMapper selectorMapper, ApplicationEventPublisher eventPublisher, PluginMapper pluginMapper, SelectorConditionMapper selectorConditionMapper, ShenyuRegisterCenterConfig shenyuRegisterCenterConfig, SelectorHandleConverterFactor converterFactor, DiscoveryUpstreamService discoveryUpstreamService) {
        this.selectorMapper = selectorMapper;
        this.eventPublisher = eventPublisher;
        this.pluginMapper = pluginMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.converterFactor = converterFactor;
        this.discoveryUpstreamService = discoveryUpstreamService;
        Properties props = shenyuRegisterCenterConfig.getProps();
        this.checked = Boolean.parseBoolean(props.getProperty("checked", "false"));
        this.scheduledThreads = Integer.parseInt(props.getProperty("zombieCheckThreads", "10"));
        this.zombieCheckTimes = Integer.parseInt(props.getProperty("zombieCheckTimes", "5"));
        this.scheduledTime = Integer.parseInt(props.getProperty("scheduledTime", "10"));
        this.registerType = shenyuRegisterCenterConfig.getRegisterType();
        zombieRemovalTimes = Integer.parseInt(props.getProperty("zombieRemovalTimes", "60"));
    }

    public void setup() {
        if (REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType) && this.checked) {
            LOG.info("setup upstream check task");
            this.fetchUpstreamData();
            this.executor = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"scheduled-upstream-task", (boolean)false));
            this.scheduledFuture = this.executor.scheduleWithFixedDelay(this::scheduled, 10L, this.scheduledTime, TimeUnit.SECONDS);
            ThreadFactory requestFactory = ShenyuThreadFactory.create((String)"upstream-health-check-request", (boolean)true);
            this.invokeExecutor = new ScheduledThreadPoolExecutor((int)this.scheduledThreads, requestFactory);
        }
    }

    @PreDestroy
    public void close() {
        if (this.checked) {
            if (Objects.nonNull(this.scheduledFuture)) {
                this.scheduledFuture.cancel(false);
            }
            if (Objects.nonNull(this.executor)) {
                this.executor.shutdown();
            }
        }
    }

    public static void removeByKey(String selectorId) {
        UPSTREAM_MAP.remove(selectorId);
    }

    public void submit(String selectorId, CommonUpstream commonUpstream) {
        if (!REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType) || !this.checked) {
            return;
        }
        Optional.ofNullable(this.submitJust(selectorId, commonUpstream)).ifPresent(upstreams -> this.executor.execute(() -> this.updateHandler(selectorId, (List<CommonUpstream>)upstreams, (List<CommonUpstream>)upstreams)));
    }

    private List<CommonUpstream> submitJust(String selectorId, CommonUpstream commonUpstream) {
        if (!REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType) || !this.checked) {
            return null;
        }
        List upstreams = (List)MapUtils.computeIfAbsent(UPSTREAM_MAP, (Object)selectorId, k -> new CopyOnWriteArrayList());
        if (commonUpstream.isStatus()) {
            Optional<CommonUpstream> exists = upstreams.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUpstreamUrl()) && item.getUpstreamUrl().equals(commonUpstream.getUpstreamUrl())).findFirst();
            if (!exists.isPresent()) {
                upstreams.add(commonUpstream);
            } else {
                LOG.info("upstream host {} is exists.", (Object)commonUpstream.getUpstreamHost());
            }
            PENDING_SYNC.add(commonUpstream.hashCode());
        } else {
            upstreams.removeIf(item -> item.equals((Object)commonUpstream));
            PENDING_SYNC.add(NumberUtils.INTEGER_ZERO);
        }
        return upstreams;
    }

    public boolean checkAndSubmit(String selectorId, CommonUpstream commonUpstream) {
        boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
        if (pass) {
            this.submit(selectorId, commonUpstream);
            return false;
        }
        ZOMBIE_SET.add(ZombieUpstream.transform((CommonUpstream)commonUpstream, (int)this.zombieCheckTimes, (String)selectorId));
        LOG.error("add zombie node, url={}", (Object)commonUpstream.getUpstreamUrl());
        return true;
    }

    public void replace(String selectorId, List<CommonUpstream> commonUpstreams) {
        if (!REGISTER_TYPE_HTTP.equalsIgnoreCase(this.registerType)) {
            return;
        }
        UPSTREAM_MAP.put(selectorId, commonUpstreams);
    }

    private void scheduled() {
        try {
            this.doCheck();
            this.waitFinish();
        }
        catch (Exception e) {
            LOG.error("upstream scheduled check error -------- ", (Throwable)e);
        }
    }

    private void doCheck() {
        if (!ZOMBIE_SET.isEmpty()) {
            ZOMBIE_SET.forEach(this::checkZombie);
        }
        if (!UPSTREAM_MAP.isEmpty()) {
            UPSTREAM_MAP.forEach(this::check);
        }
    }

    private void waitFinish() {
        CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[0])).join();
        this.futures.clear();
    }

    private void checkZombie(ZombieUpstream zombieUpstream) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.checkZombie0(zombieUpstream), this.invokeExecutor);
        this.futures.add(future);
    }

    private void checkZombie0(ZombieUpstream zombieUpstream) {
        ZOMBIE_SET.remove(zombieUpstream);
        String selectorId = zombieUpstream.getSelectorId();
        CommonUpstream commonUpstream = zombieUpstream.getCommonUpstream();
        boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
        if (pass) {
            commonUpstream.setTimestamp(System.currentTimeMillis());
            commonUpstream.setStatus(true);
            LOG.info("UpstreamCacheManager check zombie upstream success the url: {}, host: {} ", (Object)commonUpstream.getUpstreamUrl(), (Object)commonUpstream.getUpstreamHost());
            List old = ListUtils.unmodifiableList(UPSTREAM_MAP.getOrDefault(selectorId, Collections.emptyList()));
            this.submitJust(selectorId, commonUpstream);
            this.updateHandler(selectorId, old, UPSTREAM_MAP.get(selectorId));
        } else {
            LOG.error("check zombie upstream the url={} is fail", (Object)commonUpstream.getUpstreamUrl());
            if (zombieUpstream.getZombieCheckTimes() > NumberUtils.INTEGER_ZERO) {
                zombieUpstream.setZombieCheckTimes(zombieUpstream.getZombieCheckTimes() - NumberUtils.INTEGER_ONE);
                ZOMBIE_SET.add(zombieUpstream);
            }
        }
    }

    private void check(String selectorId, List<CommonUpstream> upstreamList) {
        ArrayList<CompletionStage> checkFutures = new ArrayList<CompletionStage>(upstreamList.size());
        for (CommonUpstream commonUpstream : upstreamList) {
            checkFutures.add(CompletableFuture.supplyAsync(() -> {
                boolean pass = UpstreamCheckUtils.checkUrl((String)commonUpstream.getUpstreamUrl());
                if (pass) {
                    if (!commonUpstream.isStatus()) {
                        commonUpstream.setTimestamp(System.currentTimeMillis());
                        commonUpstream.setStatus(true);
                        PENDING_SYNC.add(commonUpstream.hashCode());
                        LOG.info("UpstreamCacheManager check success the url: {}, host: {} ", (Object)commonUpstream.getUpstreamUrl(), (Object)commonUpstream.getUpstreamHost());
                    }
                    return commonUpstream;
                }
                commonUpstream.setStatus(false);
                ZOMBIE_SET.add(ZombieUpstream.transform((CommonUpstream)commonUpstream, (int)this.zombieCheckTimes, (String)selectorId));
                LOG.info("change unlive selectorId={}|url={}", (Object)selectorId, (Object)commonUpstream.getUpstreamUrl());
                this.discoveryUpstreamService.changeStatusBySelectorIdAndUrl(selectorId, commonUpstream.getUpstreamUrl(), Boolean.FALSE);
                LOG.error("check the url={} is fail ", (Object)commonUpstream.getUpstreamUrl());
                return null;
            }, this.invokeExecutor).exceptionally(ex -> {
                LOG.error("An exception occurred during the check of url {}: ", (Object)commonUpstream.getUpstreamUrl(), ex);
                return null;
            }));
        }
        this.futures.add(CompletableFuture.runAsync(() -> {
            List<CommonUpstream> successList = checkFutures.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
            this.updateHandler(selectorId, upstreamList, successList);
        }));
    }

    private void updateHandler(String selectorId, List<CommonUpstream> upstreamList, List<CommonUpstream> successList) {
        if (successList.size() == upstreamList.size() && PENDING_SYNC.isEmpty()) {
            return;
        }
        this.removePendingSync(successList);
        if (!successList.isEmpty()) {
            UPSTREAM_MAP.put(selectorId, successList);
            this.updateSelectorHandler(selectorId, successList);
        } else {
            UPSTREAM_MAP.remove(selectorId);
            this.updateSelectorHandler(selectorId, new ArrayList<CommonUpstream>());
        }
    }

    private void removePendingSync(List<CommonUpstream> successList) {
        PENDING_SYNC.removeIf(NumberUtils.INTEGER_ZERO::equals);
        successList.forEach(commonUpstream -> PENDING_SYNC.remove(commonUpstream.hashCode()));
    }

    private void updateSelectorHandler(String selectorId, List<CommonUpstream> aliveList) {
        SelectorDO selectorDO = this.selectorMapper.selectById(selectorId);
        if (Objects.isNull(selectorDO)) {
            return;
        }
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return;
        }
        String pluginName = pluginDO.getName();
        String handler = this.converterFactor.newInstance(pluginName).handler(selectorDO.getHandle(), aliveList);
        selectorDO.setHandle(handler);
        this.selectorMapper.updateSelective(selectorDO);
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        SelectorData selectorData = SelectorDO.transFrom(selectorDO, pluginName, conditionDataList);
        selectorData.setHandle(handler);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        List<Object> discoveryUpstreamDataList = this.discoveryUpstreamService.findBySelectorId(selectorId);
        if (CollectionUtils.isEmpty(discoveryUpstreamDataList)) {
            discoveryUpstreamDataList = aliveList.stream().map(DiscoveryTransfer.INSTANCE::mapToDiscoveryUpstreamData).collect(Collectors.toList());
        }
        discoveryUpstreamDataList.removeIf(u -> {
            for (CommonUpstream alive : aliveList) {
                if (!alive.getUpstreamUrl().equals(u.getUrl())) continue;
                return false;
            }
            return true;
        });
        discoveryUpstreamDataList.forEach(upstream -> {
            LOG.info("change alive selectorId={}|url={}", (Object)selectorId, (Object)upstream.getUrl());
            this.discoveryUpstreamService.changeStatusBySelectorIdAndUrl(selectorId, upstream.getUrl(), Boolean.TRUE);
        });
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
        discoverySyncData.setPluginName(pluginName);
        discoverySyncData.setSelectorId(selectorId);
        discoverySyncData.setSelectorName(selectorDO.getName());
        discoverySyncData.setNamespaceId(selectorDO.getNamespaceId());
        LOG.debug("UpstreamCacheManager update selectorId={}|json={}", (Object)selectorId, (Object)GsonUtils.getGson().toJson((Object)discoverySyncData));
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData)));
    }

    public void fetchUpstreamData() {
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(PluginEnum.getUpstreamNames());
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return;
        }
        Map<String, String> pluginMap = pluginDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, PluginDO::getName, (value1, value2) -> value1));
        List<SelectorDO> selectorDOList = this.selectorMapper.findByPluginIds(new ArrayList<String>(pluginMap.keySet()));
        long currentTimeMillis = System.currentTimeMillis();
        Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).forEach(selectorDO -> {
            String name = (String)pluginMap.get(selectorDO.getPluginId());
            LinkedList commonUpstreams = new LinkedList();
            this.discoveryUpstreamService.findBySelectorId(selectorDO.getId()).stream().map(DiscoveryTransfer.INSTANCE::mapToCommonUpstream).forEach(commonUpstreams::add);
            String handle = selectorDO.getHandle();
            if (StringUtils.isNotEmpty((CharSequence)handle)) {
                commonUpstreams.addAll(this.converterFactor.newInstance(name).convertUpstream(handle).stream().filter(upstream -> upstream.isStatus() || upstream.getTimestamp() > currentTimeMillis - TimeUnit.SECONDS.toMillis(zombieRemovalTimes)).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(commonUpstreams)) {
                UPSTREAM_MAP.put(selectorDO.getId(), commonUpstreams);
                PENDING_SYNC.add(NumberUtils.INTEGER_ZERO);
            }
        });
    }

    @EventListener(value={DiscoveryStreamUpdatedEvent.class})
    public void onDiscoveryUpstreamUpdated(DiscoveryStreamUpdatedEvent event) {
        DiscoverySyncData discoverySyncData = event.getDiscoverySyncData();
        LOG.info("onDiscoveryUpstreamUpdated plugin={}|list={}", (Object)discoverySyncData.getPluginName(), (Object)discoverySyncData.getUpstreamDataList());
        if (PluginEnum.DIVIDE.getName().equals(discoverySyncData.getPluginName())) {
            List upstreamDataList = discoverySyncData.getUpstreamDataList();
            List collect = upstreamDataList.stream().map(DiscoveryTransfer.INSTANCE::mapToCommonUpstream).collect(Collectors.toList());
            List<CommonUpstream> commonUpstreams = CommonUpstreamUtils.convertCommonUpstreamList(collect);
            LOG.info("UpstreamCacheManager replace selectorId={}|json={}", (Object)discoverySyncData.getSelectorId(), (Object)GsonUtils.getGson().toJson(commonUpstreams));
            this.replace(discoverySyncData.getSelectorId(), commonUpstreams);
        }
    }

    public static int getZombieRemovalTimes() {
        return zombieRemovalTimes;
    }
}

