/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.TagMapper;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.TagDO;
import org.apache.shenyu.admin.model.query.TagQuery;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.TagService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
implements TagService {
    private final TagMapper tagMapper;

    public TagServiceImpl(TagMapper tagMapper) {
        this.tagMapper = tagMapper;
    }

    @Override
    public int create(TagDTO tagDTO) {
        tagDTO.setParentTagId(StringUtils.isNotEmpty((CharSequence)tagDTO.getParentTagId()) ? tagDTO.getParentTagId() : "0");
        return this.createInner(tagDTO, null);
    }

    @Override
    public int createRootTag(TagDTO tagDTO, TagDO.TagExt tagExt) {
        Assert.notNull(tagDTO, "tagDTO is not allowed null");
        tagDTO.setParentTagId(StringUtils.isNotEmpty((CharSequence)tagDTO.getParentTagId()) ? tagDTO.getParentTagId() : "0");
        return this.createInner(tagDTO, tagExt);
    }

    private int createInner(TagDTO tagDTO, TagDO.TagExt tagExt) {
        TagDO tagDO;
        Assert.notNull(tagDTO, "tagDTO is not allowed null");
        Assert.notNull(tagDTO.getParentTagId(), "parent tag id is not allowed null");
        String ext = "";
        if (!tagDTO.getParentTagId().equals("0")) {
            tagDO = this.tagMapper.selectByPrimaryKey(tagDTO.getParentTagId());
            ext = this.buildExtParamByParentTag(tagDO);
        } else {
            ext = GsonUtils.getInstance().toJson((Object)Optional.ofNullable(tagExt).orElse(new TagDO.TagExt()));
        }
        tagDO = TagDO.buildTagDO(tagDTO);
        tagDO.setExt(ext);
        tagDTO.setId(tagDO.getId());
        return this.tagMapper.insert(tagDO);
    }

    @Override
    public int update(TagDTO tagDTO) {
        TagDO before = this.tagMapper.selectByPrimaryKey(tagDTO.getId());
        Assert.notNull(before, "the updated tag is not found");
        TagDO tagDO = TagDO.buildTagDO(tagDTO);
        this.updateSubTags(tagDTO);
        return this.tagMapper.updateByPrimaryKeySelective(tagDO);
    }

    @Override
    public int updateTagExt(String tagId, TagDO.TagExt tagExt) {
        Assert.notNull(tagId, "tagId is not null");
        Assert.notNull(tagExt, "tagDO is not null");
        TagDO tagDO = new TagDO();
        tagDO.setId(tagId);
        tagDO.setDateUpdated(new Timestamp(System.currentTimeMillis()));
        tagDO.setExt(GsonUtils.getInstance().toJson((Object)tagExt));
        return this.tagMapper.updateByPrimaryKeySelective(tagDO);
    }

    @Override
    public int delete(List<String> ids) {
        return this.tagMapper.deleteByIds(ids);
    }

    @Override
    public TagVO findById(String id) {
        TagDO tagDO = this.tagMapper.selectByPrimaryKey(id);
        return TagVO.buildTagVO(tagDO);
    }

    @Override
    public List<TagVO> findByQuery(String tagName) {
        return this.findByQuery(tagName, null);
    }

    @Override
    public List<TagVO> findByQuery(String tagName, String parentTagId) {
        TagQuery tagQuery = new TagQuery();
        tagQuery.setName(tagName);
        tagQuery.setParentTagId(parentTagId);
        List<TagDO> tagDOS = Optional.ofNullable(this.tagMapper.selectByQuery(tagQuery)).orElse(Lists.newArrayList());
        return tagDOS.stream().map(TagVO::buildTagVO).collect(Collectors.toList());
    }

    @Override
    public List<TagVO> findByParentTagId(String parentTagId) {
        TagQuery tagQuery = new TagQuery();
        tagQuery.setParentTagId(parentTagId);
        List<TagDO> tagDOS = this.tagMapper.selectByQuery(tagQuery);
        if (CollectionUtils.isEmpty(tagDOS)) {
            return Lists.newArrayList();
        }
        List<String> rootIds = tagDOS.stream().map(BaseDO::getId).collect(Collectors.toList());
        List<TagDO> tagDOList = this.tagMapper.selectByParentTagIds(rootIds);
        Map map = tagDOList.stream().collect(Collectors.toMap(TagDO::getParentTagId, tagDO -> true, (a, b) -> b, ConcurrentHashMap::new));
        return tagDOS.stream().map(tag -> {
            TagVO tagVO = TagVO.buildTagVO(tag);
            if (map.get(tag.getId()) != null) {
                tagVO.setHasChildren((Boolean)map.get(tag.getId()));
            }
            return tagVO;
        }).collect(Collectors.toList());
    }

    private void updateSubTags(TagDTO tagDTO) {
        List<TagDO> allData = this.tagMapper.selectByQuery(new TagQuery());
        Map allDataMap = allData.stream().collect(Collectors.toMap(BaseDO::getId, Function.identity(), (a, b) -> b, ConcurrentHashMap::new));
        TagDO update = TagDO.buildTagDO(tagDTO);
        allDataMap.put(update.getId(), update);
        ConcurrentHashMap<String, List<String>> relationMap = new ConcurrentHashMap<String, List<String>>();
        allDataMap.keySet().stream().map(allDataMap::get).forEach(tagDO -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)relationMap.get(tagDO.getParentTagId())))) {
                relationMap.put(tagDO.getParentTagId(), Lists.newArrayList((Object[])new String[]{tagDO.getId()}));
            } else {
                List list = (List)relationMap.get(tagDO.getParentTagId());
                list.add(tagDO.getId());
                relationMap.put(tagDO.getParentTagId(), list);
            }
        });
        this.recurseUpdateTag(allDataMap, relationMap, tagDTO.getId());
    }

    private void recurseUpdateTag(Map<String, TagDO> allData, Map<String, List<String>> relationMap, String id) {
        if (CollectionUtils.isEmpty((Collection)relationMap.get(id))) {
            return;
        }
        List<String> subTagIds = relationMap.get(id);
        subTagIds.stream().forEach(tagId -> {
            TagDO tagDO = (TagDO)allData.get(tagId);
            tagDO.setExt(this.buildExtParamByParentTag((TagDO)allData.get(id)));
            this.tagMapper.updateByPrimaryKey(tagDO);
            this.recurseUpdateTag(allData, relationMap, (String)tagId);
        });
    }

    private String buildExtParamByParentTag(TagDO parentTagDO) {
        String ext = "";
        if (parentTagDO.getId().equals("0")) {
            TagDO.TagExt parent = new TagDO.TagExt();
            TagDO.TagExt tagExt = new TagDO.TagExt();
            tagExt.setDesc(parentTagDO.getTagDesc());
            tagExt.setName(parentTagDO.getName());
            tagExt.setId(parentTagDO.getId());
            tagExt.setRefreshTime(parent.getRefreshTime());
            tagExt.setApiDocMd5(parent.getApiDocMd5());
            parent.setParent(tagExt);
            ext = GsonUtils.getInstance().toJson((Object)parent);
        } else {
            TagDO.TagExt parentTagExt = Optional.ofNullable((TagDO.TagExt)GsonUtils.getInstance().fromJson(parentTagDO.getExt(), TagDO.TagExt.class)).orElse(new TagDO.TagExt());
            TagDO.TagExt tagExt = new TagDO.TagExt();
            parentTagExt.setDesc(parentTagDO.getTagDesc());
            parentTagExt.setName(parentTagDO.getName());
            parentTagExt.setId(parentTagDO.getId());
            tagExt.setParent(parentTagExt);
            ext = GsonUtils.getInstance().toJson((Object)tagExt);
        }
        return ext;
    }
}

