/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.MetaDataMapper;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.MetaDataQuery;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.publish.MetaDataEventPublisher;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MetaDataServiceImpl
implements MetaDataService {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataServiceImpl.class);
    private final MetaDataMapper metaDataMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final MetaDataEventPublisher publisher;

    public MetaDataServiceImpl(MetaDataMapper metaDataMapper, ApplicationEventPublisher eventPublisher, MetaDataEventPublisher publisher) {
        this.metaDataMapper = metaDataMapper;
        this.eventPublisher = eventPublisher;
        this.publisher = publisher;
    }

    @Override
    public void saveOrUpdateMetaData(MetaDataDO exist, MetaDataRegisterDTO metaDataDTO) {
        DataEventTypeEnum eventType;
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapRegisterDTOToEntity(metaDataDTO);
        if (Objects.isNull(exist)) {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            metaDataDO.setId(UUIDUtils.getInstance().generateShortUuid());
            metaDataDO.setDateCreated(currentTime);
            metaDataDO.setDateUpdated(currentTime);
            this.metaDataMapper.insert(metaDataDO);
            eventType = DataEventTypeEnum.CREATE;
        } else {
            metaDataDO.setId(exist.getId());
            this.metaDataMapper.update(metaDataDO);
            eventType = DataEventTypeEnum.UPDATE;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, eventType, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDO))));
    }

    @Override
    public String createOrUpdate(MetaDataDTO metaDataDTO) {
        return StringUtils.isBlank((CharSequence)metaDataDTO.getId()) ? this.create(metaDataDTO) : this.update(metaDataDTO);
    }

    @Override
    public int deleteByIdsAndNamespaceId(List<String> ids, String namespaceId) {
        List<MetaDataDO> deletedMetaData = this.metaDataMapper.selectByIdListAndNamespaceId(ids, namespaceId);
        if (CollectionUtils.isEmpty(deletedMetaData)) {
            return 0;
        }
        int count = this.metaDataMapper.deleteByIdListAndNamespaceId(ids, namespaceId);
        if (count > 0) {
            this.publisher.onDeleted((Collection<MetaDataDO>)deletedMetaData);
        }
        return count;
    }

    @Override
    public String enabledByIdsAndNamespaceId(List<String> ids, Boolean enabled, String namespaceId) {
        List<MetaDataDO> metaDataDoList = this.metaDataMapper.selectByIdListAndNamespaceId(ids, namespaceId);
        if (CollectionUtils.isEmpty(metaDataDoList)) {
            return "ID NOT EXIST!";
        }
        for (MetaDataDO metaDataDO : metaDataDoList) {
            metaDataDO.setEnabled(enabled);
        }
        if (this.metaDataMapper.updateEnableBatch(ids, enabled) > 0) {
            this.publisher.onEnabled(metaDataDoList);
        }
        return "";
    }

    @Override
    public void syncData() {
        List<MetaDataDO> all = this.metaDataMapper.findAll();
        if (CollectionUtils.isNotEmpty(all)) {
            Map<String, List<MetaDataDO>> namespaceMetaDataList = all.stream().collect(Collectors.groupingBy(MetaDataDO::getNamespaceId));
            namespaceMetaDataList.values().forEach(m -> this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.REFRESH, MetaDataTransfer.INSTANCE.mapToDataAll((List<MetaDataDO>)m))));
        }
    }

    @Override
    public void syncDataByNamespaceId(String namespaceId) {
        List<MetaDataDO> all = this.metaDataMapper.findAllByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(all)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.REFRESH, MetaDataTransfer.INSTANCE.mapToDataAll(all)));
        }
    }

    @Override
    public MetaDataVO findById(String id) {
        return Optional.ofNullable(MetaDataTransfer.INSTANCE.mapToVO(this.metaDataMapper.selectById(id))).orElseGet(MetaDataVO::new);
    }

    @Override
    @Pageable
    public CommonPager<MetaDataVO> listByPage(MetaDataQuery metaDataQuery) {
        return PageResultUtils.result(metaDataQuery.getPageParameter(), () -> this.metaDataMapper.selectByQuery(metaDataQuery).stream().map(MetaDataTransfer.INSTANCE::mapToVO).collect(Collectors.toList()));
    }

    @Override
    public List<MetaDataVO> findAll() {
        return MetaDataTransfer.INSTANCE.mapToVOList(this.metaDataMapper.selectAll());
    }

    @Override
    public Map<String, List<MetaDataVO>> findAllGroup() {
        return ListUtil.groupBy(this.findAll(), MetaDataVO::getAppName);
    }

    @Override
    public List<MetaData> listAll() {
        return ListUtil.map(this.metaDataMapper.selectAll(), MetaDataTransfer.INSTANCE::mapToData);
    }

    @Override
    public List<MetaDataVO> listAllData() {
        return ListUtil.map(this.metaDataMapper.selectAll(), MetaDataTransfer.INSTANCE::mapToVO);
    }

    @Override
    public List<MetaDataVO> listAllDataByNamespaceId(String namespaceId) {
        return ListUtil.map(this.metaDataMapper.findAllByNamespaceId(namespaceId), MetaDataTransfer.INSTANCE::mapToVO);
    }

    @Override
    public MetaDataDO findByPathAndNamespaceId(String path, String namespaceId) {
        return this.metaDataMapper.findByPathAndNamespaceId(path, namespaceId);
    }

    @Override
    public MetaDataDO findByServiceNameAndMethodNameAndNamespaceId(String serviceName, String methodName, String namespaceId) {
        List<MetaDataDO> metadataList = this.metaDataMapper.findByServiceNameAndMethodAndNamespaceId(serviceName, methodName, namespaceId);
        return CollectionUtils.isEmpty(metadataList) ? null : metadataList.get(0);
    }

    @Override
    public int insert(MetaDataDO metaDataDO) {
        return this.metaDataMapper.insert(metaDataDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<MetaDataDTO> metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return ConfigImportResult.success();
        }
        Set existMetadataPathSet = Optional.of(this.listAll().stream().filter(Objects::nonNull).map(MetaData::getPath).collect(Collectors.toSet())).orElseGet(Sets::newHashSet);
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        for (MetaDataDTO metaDataDTO : metaDataList) {
            String metaDataPath = metaDataDTO.getPath();
            if (existMetadataPathSet.contains(metaDataPath)) {
                LOG.info("import metadata path: {} already exists", (Object)metaDataPath);
                errorMsgBuilder.append(metaDataPath).append(",");
                continue;
            }
            this.create(metaDataDTO);
            ++successCount;
        }
        this.syncData();
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail meta: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(String namespace, List<MetaDataDTO> metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return ConfigImportResult.success();
        }
        Set existMetadataPathSet = Optional.of(this.metaDataMapper.findAllByNamespaceId(namespace).stream().filter(Objects::nonNull).map(MetaDataDO::getPath).collect(Collectors.toSet())).orElseGet(Sets::newHashSet);
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        for (MetaDataDTO metaDataDTO : metaDataList) {
            String metaDataPath = metaDataDTO.getPath();
            if (existMetadataPathSet.contains(metaDataPath)) {
                LOG.info("import metadata path: {} already exists", (Object)metaDataPath);
                errorMsgBuilder.append(metaDataPath).append(",");
                continue;
            }
            metaDataDTO.setNamespaceId(namespace);
            this.create(metaDataDTO);
            ++successCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail meta: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    private String create(MetaDataDTO metaDataDTO) {
        Assert.isNull(this.metaDataMapper.pathExisted((Serializable)((Object)metaDataDTO.getPath()), metaDataDTO.getNamespaceId()), "The path already exists and can't be added repeatedly!");
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapToEntity(metaDataDTO);
        metaDataDO.setId(UUIDUtils.getInstance().generateShortUuid());
        metaDataDO.setPathDesc(Objects.isNull(metaDataDO.getPathDesc()) ? "" : metaDataDO.getPathDesc());
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        metaDataDO.setDateCreated(currentTime);
        metaDataDO.setDateUpdated(currentTime);
        if (this.metaDataMapper.insert(metaDataDO) > 0) {
            this.publisher.onCreated(metaDataDO);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.CREATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDO))));
        return "create success";
    }

    private String update(MetaDataDTO metaDataDTO) {
        Assert.isNull(this.metaDataMapper.pathExistedExclude((Serializable)((Object)metaDataDTO.getPath()), Collections.singletonList(metaDataDTO.getId())), "The path already exists and can't be added repeatedly!");
        MetaDataDO metaDataDO = MetaDataTransfer.INSTANCE.mapToEntity(metaDataDTO);
        Optional.ofNullable(this.metaDataMapper.selectById(metaDataDTO.getId())).ifPresent(e -> metaDataDTO.setEnabled(e.getEnabled()));
        metaDataDO.setPathDesc(Optional.ofNullable(metaDataDO.getPathDesc()).orElse(""));
        MetaDataDO before = this.metaDataMapper.selectById(metaDataDO.getId());
        if (this.metaDataMapper.update(metaDataDO) > 0) {
            this.publisher.onUpdated(metaDataDO, before);
            List befores = Optional.ofNullable(this.metaDataMapper.findByServiceNameAndMethodAndNamespaceId(metaDataDO.getServiceName(), null, metaDataDO.getNamespaceId())).orElseGet(LinkedList::new);
            for (MetaDataDO b : befores) {
                MetaDataDO update = MetaDataTransfer.INSTANCE.copy(b);
                update.setRpcExt(metaDataDTO.getRpcExt());
                if (this.metaDataMapper.update(update) <= 0) continue;
                this.publisher.onUpdated(update, b);
            }
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.UPDATE, Collections.singletonList(MetaDataTransfer.INSTANCE.mapToData(metaDataDTO))));
        return "update success";
    }
}

