/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.DiscoveryLevel;
import org.apache.shenyu.admin.discovery.DiscoveryMode;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.DiscoveryRelMapper;
import org.apache.shenyu.admin.mapper.ProxySelectorMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryRelDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.enums.DiscoveryTypeEnum;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.DiscoveryHandlerVO;
import org.apache.shenyu.admin.model.vo.DiscoveryRelVO;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.DiscoveryConfigRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiscoveryServiceImpl
implements DiscoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryServiceImpl.class);
    private final DiscoveryMapper discoveryMapper;
    private final ProxySelectorMapper proxySelectorMapper;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final DiscoveryRelMapper discoveryRelMapper;
    private final SelectorService selectorService;
    private final SelectorMapper selectorMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public DiscoveryServiceImpl(DiscoveryMapper discoveryMapper, ProxySelectorMapper proxySelectorMapper, DiscoveryRelMapper discoveryRelMapper, DiscoveryHandlerMapper discoveryHandlerMapper, SelectorService selectorService, SelectorMapper selectorMapper, DiscoveryProcessorHolder discoveryProcessorHolder) {
        this.discoveryMapper = discoveryMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
        this.proxySelectorMapper = proxySelectorMapper;
        this.discoveryRelMapper = discoveryRelMapper;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.selectorService = selectorService;
        this.selectorMapper = selectorMapper;
    }

    @Override
    public List<String> typeEnums() {
        return DiscoveryTypeEnum.types();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DiscoveryVO discovery(String pluginName, String level, String namespaceId) {
        return DiscoveryTransfer.INSTANCE.mapToVo(this.discoveryMapper.selectByPluginNameAndLevelAndNamespaceId(pluginName, level, namespaceId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DiscoveryVO createOrUpdate(DiscoveryDTO discoveryDTO) {
        return StringUtils.isBlank((CharSequence)discoveryDTO.getId()) ? this.create(discoveryDTO) : this.update(discoveryDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void registerDiscoveryConfig(DiscoveryConfigRegisterDTO discoveryConfigRegisterDTO) {
        SelectorDO selectorDO = this.findAndLockOnDB(discoveryConfigRegisterDTO.getSelectorName(), discoveryConfigRegisterDTO.getPluginName(), discoveryConfigRegisterDTO.getNamespaceId());
        this.bindingDiscovery(discoveryConfigRegisterDTO, selectorDO);
    }

    private SelectorDO findAndLockOnDB(String selectorName, String pluginName, String namespaceId) {
        SelectorDO selectorDO = null;
        for (int i = 0; i < 3; ++i) {
            selectorDO = this.selectorService.findByNameAndPluginNameAndNamespaceIdForUpdate(selectorName, pluginName, namespaceId);
            if (selectorDO != null) {
                return selectorDO;
            }
            try {
                LOG.info("retry to find selector {} : {}", (Object)selectorName, (Object)pluginName);
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new ShenyuException("when binding discovery don't find selector " + selectorName);
    }

    private void bindingDiscovery(DiscoveryConfigRegisterDTO discoveryConfigRegisterDTO, SelectorDO selectorDO) {
        DiscoveryHandlerDO discoveryHandlerDO;
        ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
        proxySelectorDTO.setName(selectorDO.getName());
        proxySelectorDTO.setId(selectorDO.getId());
        proxySelectorDTO.setPluginName(discoveryConfigRegisterDTO.getPluginName());
        proxySelectorDTO.setNamespaceId(selectorDO.getNamespaceId());
        DiscoveryDO discoveryDO = this.discoveryMapper.selectByPluginNameAndLevelAndNamespaceId(discoveryConfigRegisterDTO.getPluginName(), DiscoveryLevel.PLUGIN.getCode(), discoveryConfigRegisterDTO.getNamespaceId());
        if (discoveryDO == null) {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            discoveryDO = DiscoveryDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).name(discoveryConfigRegisterDTO.getName()).pluginName(discoveryConfigRegisterDTO.getPluginName()).level(DiscoveryLevel.PLUGIN.getCode()).type(discoveryConfigRegisterDTO.getDiscoveryType()).serverList(discoveryConfigRegisterDTO.getServerList()).props(GsonUtils.getInstance().toJson((Object)Optional.ofNullable(discoveryConfigRegisterDTO.getProps()).orElse(new Properties()))).namespaceId(discoveryConfigRegisterDTO.getNamespaceId()).dateCreated(currentTime).dateUpdated(currentTime).build();
            this.discoveryMapper.insertSelective(discoveryDO);
        }
        if ((discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(selectorDO.getId())) == null) {
            discoveryHandlerDO = DiscoveryHandlerDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).discoveryId(discoveryDO.getId()).handler(discoveryConfigRegisterDTO.getHandler()).listenerNode(discoveryConfigRegisterDTO.getListenerNode()).props(GsonUtils.getInstance().toJson((Object)Optional.ofNullable(discoveryConfigRegisterDTO.getProps()).orElse(new Properties()))).dateCreated(new Timestamp(System.currentTimeMillis())).build();
            DiscoveryRelDO discoveryRefDO = DiscoveryRelDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).discoveryHandlerId(discoveryHandlerDO.getId()).selectorId(selectorDO.getId()).pluginName(discoveryConfigRegisterDTO.getPluginName()).build();
            this.discoveryRelMapper.insertSelective(discoveryRefDO);
            this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
        }
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryConfigRegisterDTO.getDiscoveryType());
        discoveryProcessor.createDiscovery(discoveryDO);
        discoveryProcessor.createProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), proxySelectorDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(String discoveryId) {
        List<DiscoveryHandlerDO> discoveryHandlerDOS = this.discoveryHandlerMapper.selectByDiscoveryId(discoveryId);
        if (CollectionUtils.isNotEmpty(discoveryHandlerDOS)) {
            LOG.warn("shenyu this discovery has discoveryHandler can't be delete");
            throw new ShenyuException("shenyu this discovery has discoveryHandler can't be delete");
        }
        DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryId);
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        discoveryProcessor.removeDiscovery(discoveryDO);
        this.discoveryMapper.delete(discoveryId);
        return "delete success";
    }

    private DiscoveryVO create(DiscoveryDTO discoveryDTO) {
        if (discoveryDTO == null) {
            return null;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DiscoveryDO discoveryDO = DiscoveryDO.builder().id(discoveryDTO.getId()).name(discoveryDTO.getName()).pluginName(discoveryDTO.getPluginName()).namespaceId(discoveryDTO.getNamespaceId()).level(discoveryDTO.getLevel()).type(discoveryDTO.getType()).serverList(discoveryDTO.getServerList()).props(discoveryDTO.getProps()).dateCreated(currentTime).dateUpdated(currentTime).build();
        if (StringUtils.isEmpty((CharSequence)discoveryDTO.getId())) {
            discoveryDO.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        DiscoveryVO result = this.discoveryMapper.insert(discoveryDO) > 0 ? DiscoveryTransfer.INSTANCE.mapToVo(discoveryDO) : null;
        discoveryProcessor.createDiscovery(discoveryDO);
        return result;
    }

    private DiscoveryVO update(DiscoveryDTO discoveryDTO) {
        if (Objects.isNull(discoveryDTO) || Objects.isNull(discoveryDTO.getId())) {
            return null;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DiscoveryDO discoveryDO = DiscoveryDO.builder().id(discoveryDTO.getId()).name(discoveryDTO.getName()).type(discoveryDTO.getType()).serverList(discoveryDTO.getServerList()).props(discoveryDTO.getProps()).namespaceId(discoveryDTO.getNamespaceId()).dateUpdated(currentTime).build();
        return this.discoveryMapper.updateSelective(discoveryDO) > 0 ? DiscoveryTransfer.INSTANCE.mapToVo(discoveryDO) : null;
    }

    public void syncData(List<DiscoveryDO> discoveryDOS) {
        discoveryDOS.forEach(d -> {
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(d.getType());
            discoveryProcessor.createDiscovery((DiscoveryDO)d);
            this.proxySelectorMapper.selectByDiscoveryId(d.getId()).stream().map(DiscoveryTransfer.INSTANCE::mapToDTO).forEach(ps -> {
                DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectByProxySelectorId(ps.getId());
                discoveryProcessor.createProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), (ProxySelectorDTO)ps);
                discoveryProcessor.fetchAll(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), (ProxySelectorDTO)ps);
            });
            List<SelectorDO> selectorDOS = this.selectorMapper.selectByDiscoveryId(d.getId());
            for (SelectorDO selectorDO : selectorDOS) {
                ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
                proxySelectorDTO.setPluginName(d.getPluginName());
                proxySelectorDTO.setName(selectorDO.getName());
                proxySelectorDTO.setId(selectorDO.getId());
                proxySelectorDTO.setNamespaceId(selectorDO.getNamespaceId());
                DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(selectorDO.getId());
                discoveryProcessor.createProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), proxySelectorDTO);
                discoveryProcessor.fetchAll(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), proxySelectorDTO);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncData() {
        LOG.info("shenyu DiscoveryService sync db ");
        List<DiscoveryDO> discoveryDOS = this.discoveryMapper.selectAll();
        this.syncData(discoveryDOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncDataByNamespaceId(String namespaceId) {
        LOG.info("shenyu DiscoveryService sync db ");
        List<DiscoveryDO> discoveryDOS = this.discoveryMapper.selectAllByNamespaceId(namespaceId);
        this.syncData(discoveryDOS);
    }

    @Override
    public List<DiscoveryVO> listAllData() {
        Map<String, DiscoveryHandlerVO> discoveryHandlerMap = this.discoveryHandlerMapper.selectAll().stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toMap(DiscoveryHandlerVO::getDiscoveryId, x -> x));
        Map<String, DiscoveryRelVO> discoveryRelMap = this.discoveryRelMapper.selectAll().stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toMap(DiscoveryRelVO::getDiscoveryHandlerId, x -> x));
        return this.discoveryMapper.selectAll().stream().map(x -> {
            DiscoveryVO discoveryVO = DiscoveryTransfer.INSTANCE.mapToVo((DiscoveryDO)x);
            DiscoveryHandlerVO discoveryHandlerVO = discoveryHandlerMap.getOrDefault(discoveryVO.getId(), new DiscoveryHandlerVO());
            discoveryVO.setDiscoveryHandler(discoveryHandlerVO);
            if (StringUtils.isNotEmpty((CharSequence)discoveryHandlerVO.getId())) {
                DiscoveryRelVO discoveryRelVO = discoveryRelMap.getOrDefault(discoveryHandlerVO.getId(), new DiscoveryRelVO());
                discoveryVO.setDiscoveryRel(discoveryRelVO);
            }
            return discoveryVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DiscoveryVO> listAllDataByNamespaceId(String namespaceId) {
        List<DiscoveryDO> discoveryDOList = this.discoveryMapper.selectAllByNamespaceId(namespaceId);
        if (CollectionUtils.isEmpty(discoveryDOList)) {
            return Lists.newArrayList();
        }
        Set discoveryIdSet = discoveryDOList.stream().map(BaseDO::getId).collect(Collectors.toSet());
        List<DiscoveryHandlerDO> discoveryHandlerDOList = this.discoveryHandlerMapper.selectByDiscoveryIds(Lists.newArrayList(discoveryIdSet));
        Map<Object, Object> discoveryHandlerMap = Maps.newHashMap();
        Map<Object, Object> discoveryRelMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(discoveryHandlerDOList)) {
            discoveryHandlerMap = discoveryHandlerDOList.stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toMap(DiscoveryHandlerVO::getDiscoveryId, x -> x));
            discoveryRelMap = this.discoveryRelMapper.selectAll().stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toMap(DiscoveryRelVO::getDiscoveryHandlerId, x -> x));
        }
        HashMap finalDiscoveryHandlerMap = discoveryHandlerMap;
        HashMap finalDiscoveryRelMap = discoveryRelMap;
        return discoveryDOList.stream().map(x -> {
            DiscoveryVO discoveryVO = DiscoveryTransfer.INSTANCE.mapToVo((DiscoveryDO)x);
            DiscoveryHandlerVO discoveryHandlerVO = finalDiscoveryHandlerMap.getOrDefault(discoveryVO.getId(), new DiscoveryHandlerVO());
            discoveryVO.setDiscoveryHandler(discoveryHandlerVO);
            if (StringUtils.isNotEmpty((CharSequence)discoveryHandlerVO.getId())) {
                DiscoveryRelVO discoveryRelVO = finalDiscoveryRelMap.getOrDefault(discoveryHandlerVO.getId(), new DiscoveryRelVO());
                discoveryVO.setDiscoveryRel(discoveryRelVO);
            }
            return discoveryVO;
        }).collect(Collectors.toList());
    }

    @Override
    public DiscoveryHandlerDTO findDiscoveryHandlerBySelectorId(String selectorId) {
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(selectorId);
        return DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO);
    }

    @Override
    public String registerDefaultDiscovery(String selectorId, String pluginName, String namespaceId) {
        DiscoveryHandlerDO discoveryHandlerDB = this.discoveryHandlerMapper.selectBySelectorId(selectorId);
        if (Objects.nonNull(discoveryHandlerDB)) {
            return discoveryHandlerDB.getId();
        }
        DiscoveryDO discoveryDO = new DiscoveryDO();
        String discoveryId = UUIDUtils.getInstance().generateShortUuid();
        discoveryDO.setLevel(DiscoveryLevel.SELECTOR.getCode());
        discoveryDO.setName(pluginName + "_default_discovery");
        discoveryDO.setPluginName(pluginName);
        discoveryDO.setType(DiscoveryMode.LOCAL.name().toLowerCase());
        discoveryDO.setId(discoveryId);
        discoveryDO.setNamespaceId(namespaceId);
        this.discoveryMapper.insertSelective(discoveryDO);
        DiscoveryHandlerDO discoveryHandlerDO = new DiscoveryHandlerDO();
        String discoveryHandlerId = UUIDUtils.getInstance().generateShortUuid();
        discoveryHandlerDO.setId(discoveryHandlerId);
        discoveryHandlerDO.setDiscoveryId(discoveryId);
        discoveryHandlerDO.setHandler("{}");
        discoveryHandlerDO.setProps("{}");
        this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
        DiscoveryRelDO discoveryRelDO = new DiscoveryRelDO();
        String discoveryRelId = UUIDUtils.getInstance().generateShortUuid();
        discoveryRelDO.setDiscoveryHandlerId(discoveryHandlerId);
        discoveryRelDO.setId(discoveryRelId);
        discoveryRelDO.setSelectorId(selectorId);
        discoveryRelDO.setPluginName(pluginName);
        this.discoveryRelMapper.insertSelective(discoveryRelDO);
        return discoveryHandlerId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<DiscoveryDTO> discoveryList) {
        if (CollectionUtils.isEmpty(discoveryList)) {
            return ConfigImportResult.success();
        }
        Map<String, List<DiscoveryDO>> pluginDiscoveryMap = this.discoveryMapper.selectAll().stream().collect(Collectors.groupingBy(DiscoveryDO::getPluginName));
        int successCount = 0;
        StringBuilder errorMsgBuilder = new StringBuilder();
        for (DiscoveryDTO discoveryDTO : discoveryList) {
            String pluginName = discoveryDTO.getPluginName();
            String discoveryName = discoveryDTO.getName();
            Set existDiscoveryNameSet = pluginDiscoveryMap.getOrDefault(pluginName, Lists.newArrayList()).stream().map(DiscoveryDO::getName).collect(Collectors.toSet());
            if (existDiscoveryNameSet.contains(discoveryName)) {
                errorMsgBuilder.append(discoveryName).append(",");
                continue;
            }
            String discoveryId = UUIDUtils.getInstance().generateShortUuid();
            discoveryDTO.setId(discoveryId);
            this.create(discoveryDTO);
            ++successCount;
            if (null != discoveryDTO.getDiscoveryHandler()) {
                DiscoveryHandlerDO discoveryHandlerDO = DiscoveryTransfer.INSTANCE.mapToDO(discoveryDTO.getDiscoveryHandler());
                discoveryHandlerDO.setDiscoveryId(discoveryId);
                this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
            }
            if (null == discoveryDTO.getDiscoveryRel()) continue;
            DiscoveryRelDO discoveryRelDO = DiscoveryTransfer.INSTANCE.mapToDO(discoveryDTO.getDiscoveryRel());
            this.discoveryRelMapper.insertSelective(discoveryRelDO);
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail discovery: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    public ConfigImportResult importData(String namespace, List<DiscoveryDTO> discoveryList, ConfigsImportContext context) {
        if (CollectionUtils.isEmpty(discoveryList)) {
            return ConfigImportResult.success();
        }
        Map<String, String> discoveryHandlerIdMapping = context.getDiscoveryHandlerIdMapping();
        Map<String, List<DiscoveryDO>> pluginDiscoveryMap = this.discoveryMapper.selectAllByNamespaceId(namespace).stream().collect(Collectors.groupingBy(DiscoveryDO::getPluginName));
        int successCount = 0;
        StringBuilder errorMsgBuilder = new StringBuilder();
        for (DiscoveryDTO discoveryDTO : discoveryList) {
            String pluginName = discoveryDTO.getPluginName();
            String discoveryName = discoveryDTO.getName();
            Set existDiscoveryNameSet = pluginDiscoveryMap.getOrDefault(pluginName, Lists.newArrayList()).stream().map(DiscoveryDO::getName).collect(Collectors.toSet());
            if (existDiscoveryNameSet.contains(discoveryName)) {
                errorMsgBuilder.append(discoveryName).append(",");
                continue;
            }
            String discoveryId = UUIDUtils.getInstance().generateShortUuid();
            discoveryDTO.setId(discoveryId);
            discoveryDTO.setNamespaceId(namespace);
            this.create(discoveryDTO);
            ++successCount;
            String discoveryHandlerId = null;
            if (null != discoveryDTO.getDiscoveryHandler()) {
                DiscoveryHandlerDO discoveryHandlerDO = DiscoveryTransfer.INSTANCE.mapToDO(discoveryDTO.getDiscoveryHandler());
                discoveryHandlerDO.setDiscoveryId(discoveryId);
                discoveryHandlerId = UUIDUtils.getInstance().generateShortUuid();
                discoveryHandlerIdMapping.put(discoveryHandlerDO.getId(), discoveryHandlerId);
                discoveryHandlerDO.setId(discoveryHandlerId);
                this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
            }
            if (null == discoveryDTO.getDiscoveryRel()) continue;
            DiscoveryRelDO discoveryRelDO = DiscoveryTransfer.INSTANCE.mapToDO(discoveryDTO.getDiscoveryRel());
            discoveryRelDO.setDiscoveryHandlerId(discoveryHandlerId);
            Optional.ofNullable(discoveryRelDO.getSelectorId()).ifPresent(selectorId -> discoveryRelDO.setSelectorId(context.getSelectorIdMapping().get(selectorId)));
            Optional.ofNullable(discoveryRelDO.getProxySelectorId()).ifPresent(proxySelectorId -> discoveryRelDO.setProxySelectorId(context.getProxySelectorIdMapping().get(proxySelectorId)));
            discoveryRelDO.setId(UUIDUtils.getInstance().generateShortUuid());
            this.discoveryRelMapper.insertSelective(discoveryRelDO);
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail discovery: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }
}

