/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler.dynamic;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.shenyu.admin.scale.config.ScaleProperties;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class TaskSchedulerManager {
    private static final String THREAD_NAME_PREFIX = "MonitorTask-";
    private final ThreadPoolTaskScheduler scheduler;
    private final ConcurrentHashMap<String, ScheduledFuture<?>> taskMap = new ConcurrentHashMap();

    public TaskSchedulerManager(ScaleProperties scaleProperties) {
        this.scheduler = new ThreadPoolTaskScheduler();
        this.scheduler.setPoolSize(scaleProperties.getPoolSize() > 0 ? scaleProperties.getPoolSize() : 1);
        this.scheduler.setThreadNamePrefix(THREAD_NAME_PREFIX);
        this.scheduler.initialize();
    }

    public void registerMonitorTask(String taskName, Runnable task, long interval) {
        this.cancelMonitorTask(taskName);
        ScheduledFuture future = this.scheduler.scheduleAtFixedRate(task, Instant.now().plusMillis(interval), Duration.ofMillis(interval));
        this.taskMap.put(taskName, future);
    }

    public void cancelMonitorTask(String taskName) {
        ScheduledFuture<?> future = this.taskMap.remove(taskName);
        if (future != null && !future.isCancelled()) {
            future.cancel(true);
        }
    }

    public void shutdown() {
        this.taskMap.values().forEach(future -> future.cancel(true));
        this.scheduler.shutdown();
    }
}

