/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler.dynamic;

import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.apache.shenyu.admin.scale.collector.provider.MetricData;
import org.apache.shenyu.admin.scale.scaler.dynamic.ScaleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScaleRuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ScaleRuleEvaluator.class);

    public ScaleAction evaluate(MetricData metricData, ScaleRuleDO rule) {
        double value = metricData.value();
        Double max = this.parseToDouble(rule.getMaximum());
        Double min = this.parseToDouble(rule.getMinimum());
        if (max != null && value > max) {
            return new ScaleAction(ScaleAction.ActionType.SCALE_UP);
        }
        if (min != null && value < min) {
            return new ScaleAction(ScaleAction.ActionType.SCALE_DOWN);
        }
        return null;
    }

    private Double parseToDouble(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse value. cause: {} ", (Object)e.getMessage());
            return null;
        }
    }
}

