/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler;

import java.util.Comparator;
import java.util.Date;
import org.apache.shenyu.admin.model.entity.ScalePolicyDO;
import org.apache.shenyu.admin.scale.config.ScaleProperties;
import org.apache.shenyu.admin.scale.monitor.subject.MetricsMonitor;
import org.apache.shenyu.admin.scale.scaler.KubernetesScaler;
import org.apache.shenyu.admin.scale.scaler.cache.ScalePolicyCache;
import org.apache.shenyu.admin.scale.scaler.dynamic.TaskSchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScaleService {
    private static final String DYNAMIC_TASK_NAME = "DynamicScalingTask";
    private static final Logger LOG = LoggerFactory.getLogger(ScaleService.class);
    private final TaskSchedulerManager schedulerManager;
    private final MetricsMonitor metricsMonitor;
    private final ScalePolicyCache scalePolicyCache;
    private final ScaleProperties scaleProperties;
    private final KubernetesScaler kubernetesScaler;

    public ScaleService(MetricsMonitor metricsMonitor, TaskSchedulerManager schedulerManager, ScalePolicyCache scalePolicyCache, ScaleProperties scaleProperties, KubernetesScaler kubernetesScaler) {
        this.schedulerManager = schedulerManager;
        this.metricsMonitor = metricsMonitor;
        this.scalePolicyCache = scalePolicyCache;
        this.scaleProperties = scaleProperties;
        this.kubernetesScaler = kubernetesScaler;
    }

    public void executeScaling() {
        ScalePolicyDO activePolicy = this.getActivePolicy();
        if (activePolicy != null) {
            switch (activePolicy.getId()) {
                case "1": {
                    this.stopDynamicTask();
                    this.kubernetesScaler.scaleByNum(activePolicy.getNum());
                    break;
                }
                case "2": {
                    this.stopDynamicTask();
                    if (!this.isWithinTimeRange(activePolicy)) break;
                    this.kubernetesScaler.scaleByNum(activePolicy.getNum());
                    break;
                }
                case "3": {
                    this.startDynamicTask(this.scaleProperties.getMonitorInterval());
                    break;
                }
                default: {
                    this.stopDynamicTask();
                    throw new IllegalStateException("Unknown scaling policy: " + activePolicy.getId());
                }
            }
        }
    }

    private ScalePolicyDO getActivePolicy() {
        return this.scalePolicyCache.getAllPolicies().stream().filter(policy -> policy.getStatus() == 1).min(Comparator.comparingInt(ScalePolicyDO::getSort)).orElseGet(() -> {
            LOG.warn("No active scaling policy found.");
            return null;
        });
    }

    private boolean isWithinTimeRange(ScalePolicyDO policy) {
        Date now = new Date();
        return now.after(policy.getBeginTime()) && now.before(policy.getEndTime());
    }

    private void executeDynamicScaling() {
        try {
            this.metricsMonitor.monitorMetrics();
        }
        catch (Exception e) {
            LOG.error("Failed to execute dynamic scale. cause: {} ", (Object)e.getMessage());
        }
    }

    public void startDynamicTask(long interval) {
        this.schedulerManager.registerMonitorTask(DYNAMIC_TASK_NAME, this::executeDynamicScaling, interval);
    }

    public void stopDynamicTask() {
        this.schedulerManager.cancelMonitorTask(DYNAMIC_TASK_NAME);
    }
}

