/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1Scale;
import io.kubernetes.client.openapi.models.V1ScaleSpec;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.config.properties.DeploymentProperties;
import org.apache.shenyu.admin.scale.scaler.dynamic.ScaleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubernetesScaler {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesScaler.class);
    private final AppsV1Api appsV1Api;
    private final DeploymentProperties deploymentProperties;

    public KubernetesScaler(Optional<AppsV1Api> appsV1Api, DeploymentProperties deploymentProperties) {
        this.appsV1Api = appsV1Api.orElse(null);
        this.deploymentProperties = deploymentProperties;
    }

    public void scaleByAction(ScaleAction action) throws Exception {
        V1Scale scale = this.appsV1Api.readNamespacedDeploymentScale(this.deploymentProperties.getName(), this.deploymentProperties.getNamespace(), null);
        V1ScaleSpec spec = scale.getSpec();
        int currentReplicas = spec != null && spec.getReplicas() != null ? spec.getReplicas() : 0;
        int newReplicas = this.calculateNewReplicaCount(currentReplicas, action);
        this.scaleByNum(newReplicas);
    }

    public void scaleByNum(int replicaCount) {
        try {
            V1Scale scale = new V1Scale();
            Objects.requireNonNull(scale.getSpec()).setReplicas(Integer.valueOf(replicaCount));
            this.appsV1Api.replaceNamespacedDeploymentScale(this.deploymentProperties.getName(), this.deploymentProperties.getNamespace(), scale, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.error("Failed to scale deployment. Cause: {}", (Object)e.getMessage());
        }
    }

    private int calculateNewReplicaCount(int currentReplicas, ScaleAction action) {
        return switch (action.getActionType()) {
            case ScaleAction.ActionType.SCALE_UP -> currentReplicas + 1;
            case ScaleAction.ActionType.SCALE_DOWN -> Math.max(0, currentReplicas - 1);
            default -> currentReplicas;
        };
    }
}

