/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.monitor.subject;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.apache.shenyu.admin.scale.collector.PrometheusMetricsProvider;
import org.apache.shenyu.admin.scale.collector.provider.MetricData;
import org.apache.shenyu.admin.scale.monitor.observer.Observer;
import org.apache.shenyu.admin.scale.monitor.subject.Subject;
import org.apache.shenyu.admin.scale.monitor.subject.cache.ScaleRuleCache;
import org.springframework.stereotype.Component;

@Component
public class MetricsMonitor
implements Subject {
    private final List<Observer> observers = new ArrayList<Observer>();
    private final PrometheusMetricsProvider metricsProvider;
    private final ScaleRuleCache scaleRuleCache;

    public MetricsMonitor(PrometheusMetricsProvider metricsProvider, ScaleRuleCache scaleRuleCache) {
        this.metricsProvider = metricsProvider;
        this.scaleRuleCache = scaleRuleCache;
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyObservers(MetricData metricData, ScaleRuleDO rule) {
        for (Observer observer : this.observers) {
            observer.update(metricData, rule);
        }
    }

    public void monitorMetrics() {
        List<ScaleRuleDO> sortedRules = this.scaleRuleCache.getAllRules().stream().filter(rule -> rule.getStatus() == 1).sorted(Comparator.comparingInt(ScaleRuleDO::getSort)).toList();
        for (ScaleRuleDO rule2 : sortedRules) {
            MetricData metricData = this.metricsProvider.getMetricData(rule2.getMetricName());
            if (metricData == null) continue;
            this.notifyObservers(metricData, rule2);
        }
    }
}

