/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.entity.ScalePolicyDO;
import org.apache.shenyu.common.utils.DateUtils;

public class ScalePolicyVO
implements Serializable {
    private static final long serialVersionUID = 7948061709049446961L;
    private String id;
    private Integer sort;
    private Integer status;
    private Integer num;
    private String beginTime;
    private String endTime;
    private String dateCreated;
    private String dateUpdated;

    public ScalePolicyVO() {
    }

    public ScalePolicyVO(String id, Integer sort, Integer status, Integer num, String beginTime, String endTime, String dateCreated, String dateUpdated) {
        this.id = id;
        this.sort = sort;
        this.status = status;
        this.num = num;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getNum() {
        return this.num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public static ScalePolicyVO buildScalePolicyVO(ScalePolicyDO scalePolicyDO) {
        return Optional.ofNullable(scalePolicyDO).map(item -> {
            String beginTime = item.getBeginTime() != null ? DateUtils.localDateTimeToString((LocalDateTime)new Timestamp(item.getBeginTime().getTime()).toLocalDateTime()) : null;
            String endTime = item.getEndTime() != null ? DateUtils.localDateTimeToString((LocalDateTime)new Timestamp(item.getEndTime().getTime()).toLocalDateTime()) : null;
            return new ScalePolicyVO(item.getId(), item.getSort(), item.getStatus(), item.getNum(), beginTime, endTime, DateUtils.localDateTimeToString((LocalDateTime)item.getDateCreated().toLocalDateTime()), DateUtils.localDateTimeToString((LocalDateTime)item.getDateUpdated().toLocalDateTime()));
        }).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalePolicyVO that = (ScalePolicyVO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.sort, that.sort) && Objects.equals(this.status, that.status) && Objects.equals(this.num, that.num) && Objects.equals(this.beginTime, that.beginTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.dateCreated, that.dateCreated) && Objects.equals(this.dateUpdated, that.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sort, this.status, this.num, this.beginTime, this.endTime, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "ScalePolicyVO{id='" + this.id + "', sort=" + this.sort + ", status=" + this.status + ", num=" + this.num + ", beginTime='" + this.beginTime + "', endTime='" + this.endTime + "', dateCreated='" + this.dateCreated + "', dateUpdated='" + this.dateUpdated + "'}";
    }
}

