/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.UserRoleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class UserRoleDO
extends BaseDO {
    private static final long serialVersionUID = -6072114067735588550L;
    private String userId;
    private String roleId;

    public UserRoleDO() {
    }

    public UserRoleDO(String userId, String roleId) {
        this.userId = userId;
        this.roleId = roleId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public static UserRoleDOBuilder builder() {
        return new UserRoleDOBuilder();
    }

    public static UserRoleDO buildUserRoleDO(UserRoleDTO userRoleDTO) {
        return Optional.ofNullable(userRoleDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            UserRoleDO userRoleDO = UserRoleDO.builder().roleId(item.getRoleId()).userId(item.getUserId()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                userRoleDO.setId(UUIDUtils.getInstance().generateShortUuid());
                userRoleDO.setDateCreated(currentTime);
            } else {
                userRoleDO.setId(item.getId());
            }
            return userRoleDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserRoleDO that = (UserRoleDO)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.roleId, that.roleId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId, this.roleId);
    }

    public static final class UserRoleDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String userId;
        private String roleId;

        private UserRoleDOBuilder() {
        }

        public UserRoleDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserRoleDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public UserRoleDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public UserRoleDOBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UserRoleDOBuilder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public UserRoleDO build() {
            UserRoleDO userRoleDO = new UserRoleDO();
            userRoleDO.setId(this.id);
            userRoleDO.setDateCreated(this.dateCreated);
            userRoleDO.setDateUpdated(this.dateUpdated);
            userRoleDO.setUserId(this.userId);
            userRoleDO.setRoleId(this.roleId);
            return userRoleDO;
        }
    }
}

