/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ScaleRuleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class ScaleRuleDO
extends BaseDO {
    private static final long serialVersionUID = 8778323510074951149L;
    private String metricName;
    private Integer type;
    private Integer sort;
    private Integer status;
    private String minimum;
    private String maximum;

    public ScaleRuleDO() {
    }

    public ScaleRuleDO(String metricName, Integer type, Integer sort, Integer status, String minimum, String maximum) {
        this.metricName = metricName;
        this.type = type;
        this.sort = sort;
        this.status = status;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMinimum() {
        return this.minimum;
    }

    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public String getMaximum() {
        return this.maximum;
    }

    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    public static ScaleRuleDOBuilder builder() {
        return new ScaleRuleDOBuilder();
    }

    public static ScaleRuleDO buildScaleRuleDO(ScaleRuleDTO scaleRuleDTO) {
        ScaleRuleDO scaleRuleDO = new ScaleRuleDO();
        if (StringUtils.isEmpty((CharSequence)scaleRuleDTO.getId())) {
            scaleRuleDO.setId(UUIDUtils.getInstance().generateShortUuid());
            scaleRuleDO.setDateCreated(new Timestamp(System.currentTimeMillis()));
        } else {
            scaleRuleDO.setId(scaleRuleDTO.getId());
        }
        return Optional.of(scaleRuleDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            scaleRuleDO.setMetricName(item.getMetricName());
            scaleRuleDO.setType(item.getType());
            scaleRuleDO.setSort(item.getSort());
            scaleRuleDO.setStatus(item.getStatus());
            scaleRuleDO.setMinimum(item.getMinimum());
            scaleRuleDO.setMaximum(item.getMaximum());
            scaleRuleDO.setDateUpdated(currentTime);
            return scaleRuleDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleRuleDO that = (ScaleRuleDO)o;
        return Objects.equals(this.metricName, that.metricName) && Objects.equals(this.type, that.type) && Objects.equals(this.sort, that.sort) && Objects.equals(this.status, that.status) && Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.metricName, this.type, this.sort, this.status, this.minimum, this.maximum);
    }

    public static final class ScaleRuleDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String metricName;
        private Integer type;
        private Integer sort;
        private Integer status;
        private String minimum;
        private String maximum;

        private ScaleRuleDOBuilder() {
        }

        public ScaleRuleDOBuilder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public ScaleRuleDOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public ScaleRuleDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public ScaleRuleDOBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ScaleRuleDOBuilder minimum(String minimum) {
            this.minimum = minimum;
            return this;
        }

        public ScaleRuleDOBuilder maximum(String maximum) {
            this.maximum = maximum;
            return this;
        }

        public ScaleRuleDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ScaleRuleDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ScaleRuleDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ScaleRuleDO build() {
            ScaleRuleDO scaleRuleDO = new ScaleRuleDO();
            scaleRuleDO.setId(this.id);
            scaleRuleDO.setDateCreated(this.dateCreated);
            scaleRuleDO.setDateUpdated(this.dateUpdated);
            scaleRuleDO.setMetricName(this.metricName);
            scaleRuleDO.setType(this.type);
            scaleRuleDO.setSort(this.sort);
            scaleRuleDO.setStatus(this.status);
            scaleRuleDO.setMinimum(this.minimum);
            scaleRuleDO.setMaximum(this.maximum);
            return scaleRuleDO;
        }
    }
}

