/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.dto;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.validation.annotation.Existed;

public class PluginDTO
implements Serializable {
    private static final long serialVersionUID = 789913506331671329L;
    @Existed(provider=PluginMapper.class, nullOfIgnore=true, message="the plugin is not exited")
    private @Existed(provider=PluginMapper.class, nullOfIgnore=true, message="the plugin is not exited") String id;
    @NotBlank
    private String name;
    private String config;
    @NotBlank
    private String role;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer sort;
    @NotNull
    private Boolean enabled;
    private String file;
    private List<PluginHandleDTO> pluginHandleList;
    private String namespaceId;

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        if (StringUtils.isBlank((CharSequence)config)) {
            return;
        }
        this.config = config;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<PluginHandleDTO> getPluginHandleList() {
        return this.pluginHandleList;
    }

    public void setPluginHandleList(List<PluginHandleDTO> pluginHandleList) {
        this.pluginHandleList = pluginHandleList;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDTO pluginDTO = (PluginDTO)o;
        return Objects.equals(this.id, pluginDTO.id) && Objects.equals(this.name, pluginDTO.name) && Objects.equals(this.config, pluginDTO.config) && Objects.equals(this.role, pluginDTO.role) && Objects.equals(this.sort, pluginDTO.sort) && Objects.equals(this.enabled, pluginDTO.enabled) && Objects.equals(this.file, pluginDTO.file) && Objects.equals(this.pluginHandleList, pluginDTO.pluginHandleList) && Objects.equals(this.namespaceId, pluginDTO.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.config, this.role, this.sort, this.enabled, this.file, this.pluginHandleList, this.namespaceId);
    }
}

