/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mode.cluster.impl.zookeeper;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shenyu.admin.mode.cluster.impl.zookeeper.ClusterZookeeperConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterZookeeperClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterZookeeperClient.class);
    private final ClusterZookeeperConfig config;
    private final CuratorFramework client;
    private final Map<String, TreeCache> caches = new ConcurrentHashMap<String, TreeCache>();

    public ClusterZookeeperClient(ClusterZookeeperConfig zookeeperConfig) {
        this.config = zookeeperConfig;
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.config.getBaseSleepTimeMilliseconds(), this.config.getMaxRetries(), this.config.getMaxSleepTimeMilliseconds());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.config.getServerLists()).retryPolicy((RetryPolicy)retryPolicy).connectionTimeoutMs(this.config.getConnectionTimeoutMilliseconds()).sessionTimeoutMs(this.config.getSessionTimeoutMilliseconds()).namespace(this.config.getNamespace());
        if (!StringUtils.isEmpty((CharSequence)this.config.getDigest())) {
            builder.authorization("digest", this.config.getDigest().getBytes(StandardCharsets.UTF_8));
        }
        this.client = builder.build();
    }

    public void start() {
        this.client.start();
        try {
            this.client.blockUntilConnected();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted during zookeeper client starting.");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, TreeCache> cache : this.caches.entrySet()) {
            CloseableUtils.closeQuietly((Closeable)((Closeable)cache.getValue()));
        }
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public boolean isExist(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String getDirectly(String key) {
        try {
            byte[] ret = (byte[])this.client.getData().forPath(key);
            return Objects.isNull(ret) ? null : new String(ret, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String get(String key) {
        TreeCache cache = this.findFromcache(key);
        if (Objects.isNull(cache)) {
            return this.getDirectly(key);
        }
        ChildData data = cache.getCurrentData(key);
        if (Objects.isNull(data)) {
            return this.getDirectly(key);
        }
        return Objects.isNull(data.getData()) ? null : new String(data.getData(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdate(String key, String value, CreateMode mode) {
        String val = StringUtils.isEmpty((CharSequence)value) ? "" : value;
        try {
            Class<ClusterZookeeperClient> clazz = ClusterZookeeperClient.class;
            synchronized (ClusterZookeeperClient.class) {
                if (Objects.nonNull(this.client.checkExists()) && Objects.nonNull(this.client.checkExists().forPath(key))) {
                    LOGGER.debug("path exists, update zookeeper key={} with value={}", (Object)key, (Object)val);
                    this.client.setData().forPath(key, val.getBytes(StandardCharsets.UTF_8));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                LOGGER.debug("path not exists, set zookeeper key={} with value={}", (Object)key, (Object)val);
                ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, val.getBytes(StandardCharsets.UTF_8));
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.error("create or update key with value error, key:{} value:{}", new Object[]{key, value, e});
            throw new ShenyuException((Throwable)e);
        }
        {
            return;
        }
    }

    public void createOrUpdate(String key, Object value, CreateMode mode) {
        if (value != null) {
            String val = GsonUtils.getInstance().toJson(value);
            this.createOrUpdate(key, val, mode);
        } else {
            this.createOrUpdate(key, "", mode);
        }
    }

    public void delete(String key) {
        try {
            ((ChildrenDeletable)this.client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<String> getChildren(String key) {
        try {
            return (List)this.client.getChildren().forPath(key);
        }
        catch (Exception e) {
            LOGGER.error("zookeeper get child error=", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public TreeCache getCache(String path) {
        return this.caches.get(path);
    }

    public TreeCache addCache(String path, TreeCacheListener ... listeners) {
        TreeCache cache = TreeCache.newBuilder((CuratorFramework)this.client, (String)path).build();
        this.caches.put(path, cache);
        if (ArrayUtils.isNotEmpty((Object[])listeners)) {
            for (TreeCacheListener listener : listeners) {
                cache.getListenable().addListener((Object)listener);
            }
        }
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new ShenyuException("failed to add curator cache.", (Throwable)e);
        }
        return cache;
    }

    private TreeCache findFromcache(String key) {
        for (Map.Entry<String, TreeCache> cache : this.caches.entrySet()) {
            if (!key.startsWith(cache.getKey())) continue;
            return cache.getValue();
        }
        return null;
    }
}

