/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.parse.KeyValueParser;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

public class DiscoveryDataChangedEventSyncListener
implements DataChangedEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryDataChangedEventSyncListener.class);
    private final KeyValueParser keyValueParser;
    private final ApplicationEventPublisher eventPublisher;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final String discoveryHandlerId;
    private final DiscoverySyncData contextInfo;

    public DiscoveryDataChangedEventSyncListener(ApplicationEventPublisher eventPublisher, DiscoveryUpstreamMapper discoveryUpstreamMapper, KeyValueParser keyValueParser, String discoveryHandlerId, DiscoverySyncData contextInfo) {
        this.eventPublisher = eventPublisher;
        this.keyValueParser = keyValueParser;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryHandlerId = discoveryHandlerId;
        this.contextInfo = contextInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void onChange(DiscoveryDataChangedEvent event) {
        DiscoveryDataChangedEvent.Event currentEvent = event.getEvent();
        if (DiscoveryDataChangedEvent.Event.IGNORED.equals((Object)currentEvent)) {
            return;
        }
        DiscoverySyncData discoverySyncData = this.buildProxySelectorData(event.getValue());
        List upstreamDataList = discoverySyncData.getUpstreamDataList();
        if (CollectionUtils.isEmpty((Collection)upstreamDataList)) {
            LOG.warn("shenyu proxySelectorData#discoveryUpstreamList is empty");
            return;
        }
        switch (currentEvent) {
            case ADDED: {
                upstreamDataList.forEach(d -> {
                    try {
                        DiscoveryUpstreamDO discoveryUpstreamDO = this.discoveryUpstreamMapper.selectByDiscoveryHandlerIdAndUrl(this.discoveryHandlerId, d.getUrl());
                        if (Objects.isNull(discoveryUpstreamDO)) {
                            d.setId(UUIDUtils.getInstance().generateShortUuid());
                            d.setDateCreated(new Timestamp(System.currentTimeMillis()));
                            d.setDateUpdated(new Timestamp(System.currentTimeMillis()));
                            this.discoveryUpstreamMapper.insert(DiscoveryTransfer.INSTANCE.mapToDo((DiscoveryUpstreamData)d));
                            LOG.info("shenyu [DiscoveryDataChangedEventSyncListener] ADDED Upstream {}", (Object)d.getUrl());
                        }
                    }
                    catch (DuplicateKeyException ex) {
                        LOG.info("shenyu [DiscoveryDataChangedEventSyncListener]  Upstream {} exist", (Object)d.getUrl());
                    }
                });
                break;
            }
            case UPDATED: {
                upstreamDataList.stream().map(DiscoveryTransfer.INSTANCE::mapToDo).forEach(discoveryUpstreamDO -> {
                    discoveryUpstreamDO.setDiscoveryHandlerId(this.discoveryHandlerId);
                    int effect = this.discoveryUpstreamMapper.updateDiscoveryHandlerIdAndUrl((DiscoveryUpstreamDO)discoveryUpstreamDO);
                    LOG.info("shenyu [DiscoveryDataChangedEventSyncListener] UPDATE Upstream {}, effect = {} ", (Object)discoveryUpstreamDO.getUrl(), (Object)effect);
                });
                break;
            }
            case DELETED: {
                if (!CollectionUtils.isNotEmpty((Collection)upstreamDataList)) break;
                upstreamDataList.forEach(up -> {
                    this.discoveryUpstreamMapper.deleteByUrl(this.discoveryHandlerId, up.getUrl());
                    LOG.info("shenyu [DiscoveryDataChangedEventSyncListener] DELETE Upstream {}", (Object)up.getUrl());
                });
                break;
            }
            default: {
                throw new IllegalStateException("shenyu DiscoveryDataChangedEventSyncListener find IllegalState");
            }
        }
        this.fillFullyDiscoverySyncData(discoverySyncData);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    private void fillFullyDiscoverySyncData(DiscoverySyncData discoverySyncData) {
        List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByProxySelectorId(discoverySyncData.getSelectorId());
        discoveryUpstreamDOS.addAll(this.discoveryUpstreamMapper.selectBySelectorId(discoverySyncData.getSelectorId()));
        List collect = discoveryUpstreamDOS.stream().map(DiscoveryTransfer.INSTANCE::mapToData).collect(Collectors.toList());
        discoverySyncData.setUpstreamDataList(collect);
    }

    private DiscoverySyncData buildProxySelectorData(String value) {
        List<Object> discoveryUpstreamDTOS = this.keyValueParser.parseValue(value);
        discoveryUpstreamDTOS.forEach(discoveryUpstreamData -> {
            if (StringUtils.isBlank((CharSequence)discoveryUpstreamData.getNamespaceId())) {
                discoveryUpstreamData.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
            }
        });
        discoveryUpstreamDTOS = discoveryUpstreamDTOS.stream().filter(upstreamData -> this.contextInfo.getNamespaceId().equals(upstreamData.getNamespaceId())).collect(Collectors.toList());
        discoveryUpstreamDTOS.forEach(discoveryUpstreamData -> {
            discoveryUpstreamData.setDiscoveryHandlerId(this.discoveryHandlerId);
            if (StringUtils.isBlank((CharSequence)discoveryUpstreamData.getProtocol())) {
                discoveryUpstreamData.setProtocol(this.discoverySupportProtocol(this.contextInfo.getPluginName()));
            }
        });
        DiscoverySyncData data = new DiscoverySyncData();
        data.setUpstreamDataList(discoveryUpstreamDTOS);
        data.setSelectorId(this.contextInfo.getSelectorId());
        data.setSelectorName(this.contextInfo.getSelectorName());
        data.setPluginName(this.contextInfo.getPluginName());
        data.setNamespaceId(this.contextInfo.getNamespaceId());
        return data;
    }

    private String discoverySupportProtocol(String pluginName) {
        String pluginNameLower;
        switch (pluginNameLower = pluginName.toLowerCase()) {
            case "divide": 
            case "grpc": {
                return "http://";
            }
            case "websocket": {
                return "ws://";
            }
        }
        return "";
    }
}

