/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.shenyu.admin.discovery.AbstractDiscoveryProcessor;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;

public class APDiscoveryProcessor
extends AbstractDiscoveryProcessor {
    public APDiscoveryProcessor(DiscoveryUpstreamMapper discoveryUpstreamMapper) {
        super(discoveryUpstreamMapper);
    }

    @Override
    public void createProxySelector(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.getShenyuDiscoveryService(discoveryHandlerDTO.getDiscoveryId());
        String key = super.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode());
        if (Objects.isNull(shenyuDiscoveryService)) {
            throw new ShenyuAdminException(String.format("before start ProxySelector you need init DiscoveryId=%s", discoveryHandlerDTO.getDiscoveryId()));
        }
        Set<String> cacheKey = this.getCacheKey(discoveryHandlerDTO.getDiscoveryId());
        if (Objects.nonNull(cacheKey) && cacheKey.contains(key)) {
            LOG.info("shenyu discovery has watcher key = {}", (Object)key);
            return;
        }
        shenyuDiscoveryService.watch(key, this.getDiscoveryDataChangedEventListener(discoveryHandlerDTO, proxySelectorDTO));
        cacheKey.add(key);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.PROXY_SELECTOR, DataEventTypeEnum.CREATE, Collections.singletonList(DiscoveryTransfer.INSTANCE.mapToData(proxySelectorDTO)));
        this.publishEvent(dataChangedEvent);
    }
}

