/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.discovery.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosDiscoveryService
implements ShenyuDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosDiscoveryService.class);
    private static final String NAMESPACE = "nacosNameSpace";
    private final ConcurrentMap<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>();
    private NamingService namingService;
    private String groupName;
    private final ConcurrentMap<String, List<Instance>> instanceListMap = new ConcurrentHashMap<String, List<Instance>>();

    public void init(DiscoveryConfig config) {
        if (Objects.nonNull(this.namingService)) {
            LOGGER.info("Nacos naming service already registered");
            return;
        }
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        this.groupName = properties.getProperty("groupName", "SHENYU_GROUP");
        String serverAddr = config.getServerList();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty(NAMESPACE, ""));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
            LOGGER.info("Nacos naming service initialized success");
        }
        catch (NacosException e) {
            LOGGER.error("Error initializing Nacos naming service", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        try {
            List initialInstances = this.namingService.selectInstances(key, this.groupName, true);
            this.instanceListMap.put(key, initialInstances);
            for (Instance instance : initialInstances) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance(instance), DiscoveryDataChangedEvent.Event.ADDED);
                listener.onChange(dataChangedEvent);
            }
            EventListener nacosListener = event -> {
                if (event instanceof NamingEvent) {
                    try {
                        List previousInstances = (List)this.instanceListMap.get(key);
                        List currentInstances = this.namingService.selectInstances(key, this.groupName, true);
                        this.compareInstances(previousInstances, currentInstances, listener);
                        this.instanceListMap.put(key, currentInstances);
                    }
                    catch (NacosException e) {
                        throw new ShenyuException((Throwable)e);
                    }
                }
            };
            this.namingService.subscribe(key, this.groupName, nacosListener);
            this.listenerMap.put(key, nacosListener);
            LOGGER.info("Subscribed to Nacos updates for key: {}", (Object)key);
        }
        catch (NacosException e) {
            LOGGER.error("nacosDiscoveryService error watching key: {}", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unwatch(String key) {
        try {
            EventListener nacosListener = (EventListener)this.listenerMap.get(key);
            if (Objects.nonNull(nacosListener)) {
                this.namingService.unsubscribe(key, this.groupName, nacosListener);
                this.listenerMap.remove(key);
                LOGGER.info("Nacos Unwatch key: {}", (Object)key);
            }
        }
        catch (NacosException e) {
            LOGGER.error("Error removing Nacos service listener: {}", (Object)e.getMessage(), (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void register(String key, String value) {
        try {
            Instance instance = this.buildInstanceFromUpstream(key, value);
            this.namingService.registerInstance(key, this.groupName, instance);
            LOGGER.info("Registering service with key: {} and value: {}", (Object)key, (Object)value);
        }
        catch (NacosException nacosException) {
            LOGGER.error("Error registering Nacos service instance: {}", (Object)nacosException.getMessage(), (Object)nacosException);
            throw new ShenyuException((Throwable)nacosException);
        }
    }

    public List<String> getRegisterData(String key) {
        try {
            List instances = this.namingService.selectInstances(key, this.groupName, true);
            ArrayList<String> registerData = new ArrayList<String>();
            for (Instance instance : instances) {
                String data = this.buildUpstreamJsonFromInstance(instance);
                registerData.add(data);
            }
            return registerData;
        }
        catch (NacosException e) {
            LOGGER.error("Error getting Nacos service instances: {}", (Object)e.getMessage(), (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public Boolean exists(String key) {
        try {
            List instances = this.namingService.selectInstances(key, this.groupName, true);
            return !instances.isEmpty();
        }
        catch (NacosException e) {
            LOGGER.error("Error checking Nacos service existence: {}", (Object)e.getMessage(), (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            if (Objects.nonNull(this.namingService)) {
                for (Map.Entry entry : this.listenerMap.entrySet()) {
                    String key = (String)entry.getKey();
                    EventListener listener = (EventListener)entry.getValue();
                    this.namingService.unsubscribe(key, this.groupName, listener);
                }
                this.listenerMap.clear();
                this.namingService.shutDown();
                this.namingService = null;
                LOGGER.info("Shutting down NacosDiscoveryService");
            }
        }
        catch (NacosException e) {
            LOGGER.error("Error shutting down NacosDiscoveryService", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private void compareInstances(List<Instance> previousInstances, List<Instance> currentInstances, DataChangedEventListener listener) {
        Set updatedInstances;
        Set deletedInstances;
        Set addedInstances = currentInstances.stream().filter(item -> !previousInstances.contains(item)).collect(Collectors.toSet());
        if (!addedInstances.isEmpty()) {
            for (Object instance : addedInstances) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance((Instance)instance), DiscoveryDataChangedEvent.Event.ADDED);
                listener.onChange(dataChangedEvent);
            }
        }
        if (!(deletedInstances = previousInstances.stream().filter(item -> !currentInstances.contains(item)).collect(Collectors.toSet())).isEmpty()) {
            for (Instance instance : deletedInstances) {
                instance.setHealthy(false);
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance(instance), DiscoveryDataChangedEvent.Event.DELETED);
                listener.onChange(dataChangedEvent);
            }
        }
        if (!(updatedInstances = currentInstances.stream().filter(currentInstance -> previousInstances.stream().anyMatch(previousInstance -> currentInstance.getInstanceId().equals(previousInstance.getInstanceId()) && !currentInstance.equals(previousInstance))).collect(Collectors.toSet())).isEmpty()) {
            for (Instance instance : updatedInstances) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance(instance), DiscoveryDataChangedEvent.Event.UPDATED);
                listener.onChange(dataChangedEvent);
            }
        }
    }

    private String buildUpstreamJsonFromInstance(Instance instance) {
        JsonObject upstreamJson = new JsonObject();
        upstreamJson.addProperty("url", instance.getIp() + ":" + instance.getPort());
        upstreamJson.addProperty("status", (Number)(instance.isHealthy() ? 0 : 1));
        upstreamJson.addProperty("weight", (Number)instance.getWeight());
        Map metadata = instance.getMetadata();
        upstreamJson.addProperty("props", (String)metadata.get("props"));
        upstreamJson.addProperty("protocol", (String)metadata.get("protocol"));
        return GsonUtils.getInstance().toJson((Object)upstreamJson);
    }

    private Instance buildInstanceFromUpstream(String key, String value) {
        try {
            Instance instance = new Instance();
            DiscoveryUpstreamData upstreamData = (DiscoveryUpstreamData)GsonUtils.getInstance().fromJson(value, DiscoveryUpstreamData.class);
            String[] urls = upstreamData.getUrl().split(":", 2);
            instance.setServiceName(key);
            instance.setIp(urls[0]);
            instance.setPort(Integer.parseInt(urls[1]));
            instance.setWeight((double)upstreamData.getWeight());
            HashMap<String, String> metaData = new HashMap<String, String>();
            metaData.put("props", Optional.ofNullable(upstreamData.getProps()).orElse("{}"));
            metaData.put("protocol", upstreamData.getProtocol());
            instance.setMetadata(metaData);
            instance.setInstanceId(upstreamData.getUrl());
            return instance;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LOGGER.error("The json format of value is wrong: {}", (Object)jsonSyntaxException.getMessage(), (Object)jsonSyntaxException);
            throw new ShenyuException((Throwable)jsonSyntaxException);
        }
    }
}

