/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.alert.strategy;

import org.apache.shenyu.alert.exception.AlertNoticeException;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.apache.shenyu.alert.strategy.AbstractAlertNotifyHandler;
import org.apache.shenyu.alert.strategy.CommonRobotNotifyResp;
import org.apache.shenyu.common.dto.AlarmContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
final class DingTalkRobotAlertNotifyStrategy
extends AbstractAlertNotifyHandler {
    private static final String DING_TALK_WEB_HOOK_URL = "https://oapi.dingtalk.com/robot/send?access_token=";
    private static final Logger log = LoggerFactory.getLogger(DingTalkRobotAlertNotifyStrategy.class);

    DingTalkRobotAlertNotifyStrategy() {
    }

    @Override
    public void send(AlertReceiverDTO receiver, AlarmContent alert) {
        try {
            DingTalkWebHookDto dingTalkWebHookDto = new DingTalkWebHookDto();
            MarkdownDTO markdownDTO = new MarkdownDTO();
            markdownDTO.setText(this.renderContent(alert));
            markdownDTO.setTitle(alert.getTitle());
            dingTalkWebHookDto.setMarkdown(markdownDTO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)dingTalkWebHookDto, (MultiValueMap)headers);
            String webHookUrl = DING_TALK_WEB_HOOK_URL + receiver.getAccessToken();
            ResponseEntity responseEntity = this.getRestTemplate().postForEntity(webHookUrl, (Object)httpEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                assert (responseEntity.getBody() != null);
                if (((CommonRobotNotifyResp)responseEntity.getBody()).getErrCode() != 0) {
                    log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)responseEntity.getBody()).getErrMsg());
                }
            } else {
                log.warn("Send dingTalk webHook: {} Failed: {}", (Object)webHookUrl, responseEntity.getBody());
                throw new AlertNoticeException("Http StatusCode " + responseEntity.getStatusCode());
            }
            log.debug("Send dingTalk webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[DingTalk Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 5;
    }

    @Override
    protected String templateName() {
        return "alertNotifyDingTalkRobot";
    }

    private static class DingTalkWebHookDto {
        private static final String MARKDOWN = "markdown";
        private String msgtype = "markdown";
        private MarkdownDTO markdown;

        private DingTalkWebHookDto() {
        }

        public String getMsgtype() {
            return this.msgtype;
        }

        public void setMsgtype(String msgtype) {
            this.msgtype = msgtype;
        }

        public MarkdownDTO getMarkdown() {
            return this.markdown;
        }

        public void setMarkdown(MarkdownDTO markdown) {
            this.markdown = markdown;
        }
    }

    private static class MarkdownDTO {
        private String text;
        private String title;

        private MarkdownDTO() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

