/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.discovery.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.grpc.stub.StreamObserver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdDiscoveryService
implements ShenyuDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdDiscoveryService.class);
    private Client etcdClient;
    private final ConcurrentMap<String, Watch.Watcher> watchCache = new ConcurrentHashMap<String, Watch.Watcher>();
    private long leaseId;
    private long ttl;
    private long timeout;
    private volatile boolean isShuttingDown;

    public void init(DiscoveryConfig config) {
        try {
            if (this.etcdClient != null) {
                return;
            }
            Properties props = config.getProps();
            this.timeout = Long.parseLong(props.getProperty("etcdTimeout", "3000"));
            this.ttl = Long.parseLong(props.getProperty("etcdTTL", "5"));
            this.etcdClient = Client.builder().endpoints(config.getServerList().split(",")).build();
            LOGGER.info("Etcd Discovery Service initialize successfully");
            if (this.leaseId == 0L) {
                this.initLease();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing Etcd Discovery Service", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private void initLease() {
        Lease lease = null;
        try {
            lease = this.etcdClient.getLeaseClient();
            this.leaseId = ((LeaseGrantResponse)lease.grant(this.ttl).get()).getID();
            lease.keepAlive(this.leaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse leaseKeepAliveResponse) {
                }

                public void onError(Throwable throwable) {
                    if (!EtcdDiscoveryService.this.isShuttingDown) {
                        LOGGER.error("etcd lease keep alive error", throwable);
                    }
                }

                public void onCompleted() {
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("initLease error.", (Throwable)e);
            if (lease != null && this.leaseId != 0L) {
                try {
                    lease.revoke(this.leaseId).get();
                    this.leaseId = 0L;
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOGGER.error("Failed to revoke lease after initialization error.", (Throwable)ex);
                }
            }
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        try {
            GetOption build = GetOption.newBuilder().isPrefix(true).build();
            CompletableFuture getResponseCompletableFuture = this.etcdClient.getKVClient().get(this.bytesOf(key), build);
            GetResponse getResponse = (GetResponse)getResponseCompletableFuture.get();
            List kvs = getResponse.getKvs();
            for (KeyValue kv : kvs) {
                DiscoveryDataChangedEvent dataChangedEvent = new DiscoveryDataChangedEvent(kv.getKey().toString(), kv.getValue().toString(StandardCharsets.UTF_8), DiscoveryDataChangedEvent.Event.ADDED);
                listener.onChange(dataChangedEvent);
            }
            Watch watch = this.etcdClient.getWatchClient();
            WatchOption option = WatchOption.newBuilder().isPrefix(true).withPrevKV(true).build();
            Watch.Watcher watcher = watch.watch(this.bytesOf(key), option, Watch.listener(response -> {
                for (WatchEvent event : response.getEvents()) {
                    if (event.getKeyValue().getKey().equals((Object)this.bytesOf(key))) {
                        return;
                    }
                    String value = event.getKeyValue().getValue().toString(StandardCharsets.UTF_8);
                    String path = event.getKeyValue().getKey().toString(StandardCharsets.UTF_8);
                    if (!Objects.nonNull(event.getKeyValue()) || !Objects.nonNull(value)) continue;
                    listener.onChange(switch (event.getEventType()) {
                        case WatchEvent.EventType.PUT -> event.getKeyValue().getCreateRevision() == event.getKeyValue().getModRevision() ? new DiscoveryDataChangedEvent(path, value, DiscoveryDataChangedEvent.Event.ADDED) : new DiscoveryDataChangedEvent(path, value, DiscoveryDataChangedEvent.Event.UPDATED);
                        case WatchEvent.EventType.DELETE -> new DiscoveryDataChangedEvent(path, event.getPrevKV().getValue().toString(StandardCharsets.UTF_8), DiscoveryDataChangedEvent.Event.DELETED);
                        default -> new DiscoveryDataChangedEvent(path, value, DiscoveryDataChangedEvent.Event.IGNORED);
                    });
                }
            }));
            this.watchCache.put(key, watcher);
            LOGGER.info("Added etcd watcher for key: {}", (Object)key);
        }
        catch (Exception e) {
            LOGGER.error("etcd client watch key: {} error", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unwatch(String key) {
        if (this.watchCache.containsKey(key)) {
            ((Watch.Watcher)this.watchCache.remove(key)).close();
            LOGGER.info("Unwatched etcd key: {}", (Object)key);
        }
    }

    public void register(String key, String value) {
        try {
            KV kvClient = this.etcdClient.getKVClient();
            String uuid = UUIDUtils.getInstance().generateShortUuid();
            PutOption putOption = PutOption.newBuilder().withPrevKV().withLeaseId(this.leaseId).build();
            kvClient.put(this.bytesOf(key + "/" + uuid), this.bytesOf(value), putOption).get(this.timeout, TimeUnit.MILLISECONDS);
            LOGGER.info("etcd client key: {} with value: {}", (Object)key, (Object)value);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("etcd client register (key:{},value:{}) error.", new Object[]{key, value, e});
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<String> getRegisterData(String key) {
        try {
            KV kvClient = this.etcdClient.getKVClient();
            GetOption option = GetOption.newBuilder().isPrefix(true).build();
            GetResponse response = (GetResponse)kvClient.get(this.bytesOf(key), option).get();
            return response.getKvs().stream().filter(o -> !o.getKey().equals((Object)ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8))).map(kv -> kv.getValue().toString(StandardCharsets.UTF_8)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("etcd client get registered data with key: {} error", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public Boolean exists(String key) {
        try {
            KV kvClient = this.etcdClient.getKVClient();
            GetOption option = GetOption.newBuilder().isPrefix(true).withCountOnly(true).build();
            GetResponse response = (GetResponse)kvClient.get(this.bytesOf(key), option).get();
            return response.getCount() > 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.isShuttingDown = true;
            for (Map.Entry entry : this.watchCache.entrySet()) {
                Watch.Watcher watcher = (Watch.Watcher)entry.getValue();
                watcher.close();
            }
            this.watchCache.clear();
            if (Objects.nonNull(this.etcdClient)) {
                this.etcdClient.close();
                this.etcdClient = null;
                this.leaseId = 0L;
            }
            LOGGER.info("Shutting down EtcdDiscoveryService");
        }
        catch (Exception e) {
            LOGGER.error("etcd client shutdown error", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
        finally {
            this.isShuttingDown = false;
        }
    }

    private ByteSequence bytesOf(String val) {
        return ByteSequence.from((String)val, (Charset)StandardCharsets.UTF_8);
    }
}

