/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.enums.HeaderUniqueStrategyEnum;

public class RequestHandle {
    private ShenyuRequestHeader header;
    private ShenyuRequestParameter parameter;
    private ShenyuCookie cookie;
    private Boolean preserveHost = Boolean.FALSE;
    private HeaderUniqueStrategyEnum requestHeaderUniqueStrategy = HeaderUniqueStrategyEnum.RETAIN_FIRST;
    private String requestUniqueHeaders;
    private HeaderUniqueStrategyEnum respHeaderUniqueStrategy = HeaderUniqueStrategyEnum.RETAIN_FIRST;
    private String respUniqueHeaders;

    public ShenyuRequestHeader getHeader() {
        return this.header;
    }

    public void setHeader(ShenyuRequestHeader header) {
        this.header = header;
    }

    public ShenyuRequestParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(ShenyuRequestParameter parameter) {
        this.parameter = parameter;
    }

    public ShenyuCookie getCookie() {
        return this.cookie;
    }

    public void setCookie(ShenyuCookie cookie) {
        this.cookie = cookie;
    }

    public Boolean getPreserveHost() {
        return this.preserveHost;
    }

    public void setPreserveHost(Boolean preserveHost) {
        this.preserveHost = preserveHost;
    }

    public HeaderUniqueStrategyEnum getRequestHeaderUniqueStrategy() {
        return this.requestHeaderUniqueStrategy;
    }

    public void setRequestHeaderUniqueStrategy(HeaderUniqueStrategyEnum requestHeaderUniqueStrategy) {
        this.requestHeaderUniqueStrategy = requestHeaderUniqueStrategy;
    }

    public String getRequestUniqueHeaders() {
        return this.requestUniqueHeaders;
    }

    public void setRequestUniqueHeaders(String requestUniqueHeaders) {
        this.requestUniqueHeaders = requestUniqueHeaders;
    }

    public HeaderUniqueStrategyEnum getRespHeaderUniqueStrategy() {
        return this.respHeaderUniqueStrategy;
    }

    public void setRespHeaderUniqueStrategy(HeaderUniqueStrategyEnum respHeaderUniqueStrategy) {
        this.respHeaderUniqueStrategy = respHeaderUniqueStrategy;
    }

    public String getRespUniqueHeaders() {
        return this.respUniqueHeaders;
    }

    public void setRespUniqueHeaders(String respUniqueHeaders) {
        this.respUniqueHeaders = respUniqueHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHandle that = (RequestHandle)o;
        return Objects.equals(this.header, that.header) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.cookie, that.cookie);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.parameter, this.cookie);
    }

    public String toString() {
        return "RequestHandle{header=" + this.header + ", parameter=" + this.parameter + ", cookie=" + this.cookie + "}";
    }

    public boolean isEmptyConfig() {
        return !this.isNotEmptyConfig();
    }

    private boolean isNotEmptyConfig() {
        return this.header.isNotEmptyConfig() || this.parameter.isNotEmptyConfig() || this.cookie.isNotEmptyConfig();
    }

    public class ShenyuRequestHeader {
        private Map<String, String> addHeaders;
        private Map<String, String> replaceHeaderKeys;
        private Map<String, String> setHeaders;
        private Set<String> removeHeaderKeys;

        public ShenyuRequestHeader() {
        }

        public ShenyuRequestHeader(Map<String, String> addHeaders, Map<String, String> replaceHeaderKeys, Map<String, String> setHeaders, Set<String> removeHeaderKeys) {
            this.addHeaders = addHeaders;
            this.replaceHeaderKeys = replaceHeaderKeys;
            this.setHeaders = setHeaders;
            this.removeHeaderKeys = removeHeaderKeys;
        }

        public Map<String, String> getAddHeaders() {
            return this.addHeaders;
        }

        public void setAddHeaders(Map<String, String> addHeaders) {
            this.addHeaders = addHeaders;
        }

        public Map<String, String> getReplaceHeaderKeys() {
            return this.replaceHeaderKeys;
        }

        public void setReplaceHeaderKeys(Map<String, String> replaceHeaderKeys) {
            this.replaceHeaderKeys = replaceHeaderKeys;
        }

        public Map<String, String> getSetHeaders() {
            return this.setHeaders;
        }

        public void setSetHeaders(Map<String, String> setHeaders) {
            this.setHeaders = setHeaders;
        }

        public Set<String> getRemoveHeaderKeys() {
            return this.removeHeaderKeys;
        }

        public void setRemoveHeaderKeys(Set<String> removeHeaderKeys) {
            this.removeHeaderKeys = removeHeaderKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShenyuRequestHeader that = (ShenyuRequestHeader)o;
            return Objects.equals(this.addHeaders, that.addHeaders) && Objects.equals(this.replaceHeaderKeys, that.replaceHeaderKeys) && Objects.equals(this.setHeaders, that.setHeaders) && Objects.equals(this.removeHeaderKeys, that.removeHeaderKeys);
        }

        public int hashCode() {
            return Objects.hash(this.addHeaders, this.replaceHeaderKeys, this.setHeaders, this.removeHeaderKeys);
        }

        public String toString() {
            return "ShenyuRequestHeader{addHeaders=" + this.addHeaders + ", replaceHeaderKeys=" + this.replaceHeaderKeys + ", setHeaders=" + this.setHeaders + ", removeHeaderKeys=" + this.removeHeaderKeys + "}";
        }

        public boolean isNotEmptyConfig() {
            return MapUtils.isNotEmpty(this.addHeaders) || MapUtils.isNotEmpty(this.replaceHeaderKeys) || MapUtils.isNotEmpty(this.setHeaders) || CollectionUtils.isNotEmpty(this.removeHeaderKeys);
        }
    }

    public class ShenyuRequestParameter {
        private Map<String, String> addParameters;
        private Map<String, String> replaceParameterKeys;
        private Map<String, String> setParameters;
        private Set<String> removeParameterKeys;

        public ShenyuRequestParameter() {
        }

        public ShenyuRequestParameter(Map<String, String> addParameters, Map<String, String> replaceParameterKeys, Map<String, String> setParameters, Set<String> removeParameterKeys) {
            this.addParameters = addParameters;
            this.replaceParameterKeys = replaceParameterKeys;
            this.setParameters = setParameters;
            this.removeParameterKeys = removeParameterKeys;
        }

        public Map<String, String> getAddParameters() {
            return this.addParameters;
        }

        public void setAddParameters(Map<String, String> addParameters) {
            this.addParameters = addParameters;
        }

        public Map<String, String> getReplaceParameterKeys() {
            return this.replaceParameterKeys;
        }

        public void setReplaceParameterKeys(Map<String, String> replaceParameterKeys) {
            this.replaceParameterKeys = replaceParameterKeys;
        }

        public Map<String, String> getSetParameters() {
            return this.setParameters;
        }

        public void setSetParameters(Map<String, String> setParameters) {
            this.setParameters = setParameters;
        }

        public Set<String> getRemoveParameterKeys() {
            return this.removeParameterKeys;
        }

        public void setRemoveParameterKeys(Set<String> removeParameterKeys) {
            this.removeParameterKeys = removeParameterKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShenyuRequestParameter that = (ShenyuRequestParameter)o;
            return Objects.equals(this.addParameters, that.addParameters) && Objects.equals(this.replaceParameterKeys, that.replaceParameterKeys) && Objects.equals(this.setParameters, that.setParameters) && Objects.equals(this.removeParameterKeys, that.removeParameterKeys);
        }

        public String toString() {
            return "ShenyuRequestParameter{addParameters=" + this.addParameters + ", replaceParameterKeys=" + this.replaceParameterKeys + ", setParameters=" + this.setParameters + ", removeParameterKeys=" + this.removeParameterKeys + "}";
        }

        public int hashCode() {
            return Objects.hash(this.addParameters, this.replaceParameterKeys, this.setParameters, this.removeParameterKeys);
        }

        public boolean isNotEmptyConfig() {
            return MapUtils.isNotEmpty(this.addParameters) || MapUtils.isNotEmpty(this.replaceParameterKeys) || MapUtils.isNotEmpty(this.setParameters) || CollectionUtils.isNotEmpty(this.removeParameterKeys);
        }
    }

    public class ShenyuCookie {
        private Map<String, String> addCookies;
        private Map<String, String> replaceCookieKeys;
        private Map<String, String> setCookies;
        private Set<String> removeCookieKeys;

        public ShenyuCookie() {
        }

        public ShenyuCookie(Map<String, String> addCookies, Map<String, String> replaceCookieKeys, Map<String, String> setCookies, Set<String> removeCookieKeys) {
            this.addCookies = addCookies;
            this.replaceCookieKeys = replaceCookieKeys;
            this.setCookies = setCookies;
            this.removeCookieKeys = removeCookieKeys;
        }

        public Map<String, String> getAddCookies() {
            return this.addCookies;
        }

        public void setAddCookies(Map<String, String> addCookies) {
            this.addCookies = addCookies;
        }

        public Map<String, String> getReplaceCookieKeys() {
            return this.replaceCookieKeys;
        }

        public void setReplaceCookieKeys(Map<String, String> replaceCookieKeys) {
            this.replaceCookieKeys = replaceCookieKeys;
        }

        public Map<String, String> getSetCookies() {
            return this.setCookies;
        }

        public void setSetCookies(Map<String, String> setCookies) {
            this.setCookies = setCookies;
        }

        public Set<String> getRemoveCookieKeys() {
            return this.removeCookieKeys;
        }

        public void setRemoveCookieKeys(Set<String> removeCookieKeys) {
            this.removeCookieKeys = removeCookieKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShenyuCookie that = (ShenyuCookie)o;
            return Objects.equals(this.addCookies, that.addCookies) && Objects.equals(this.replaceCookieKeys, that.replaceCookieKeys) && Objects.equals(this.setCookies, that.setCookies) && Objects.equals(this.removeCookieKeys, that.removeCookieKeys);
        }

        public int hashCode() {
            return Objects.hash(this.addCookies, this.replaceCookieKeys, this.setCookies, this.removeCookieKeys);
        }

        public String toString() {
            return "ShenyuCookie{addCookies=" + this.addCookies + ", replaceCookieKeys=" + this.replaceCookieKeys + ", setCookies=" + this.setCookies + ", removeCookieKeys=" + this.removeCookieKeys + "}";
        }

        public boolean isNotEmptyConfig() {
            return MapUtils.isNotEmpty(this.addCookies) || MapUtils.isNotEmpty(this.replaceCookieKeys) || MapUtils.isNotEmpty(this.setCookies) || CollectionUtils.isNotEmpty(this.removeCookieKeys);
        }
    }
}

