/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shenyu.common.concurrent.MemoryLimitCalculator;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.constant.Constants;
import org.checkerframework.checker.nullness.qual.NonNull;

@ThreadSafe
public class MemorySafeWindowTinyLFUMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -3288161459386389022L;
    private static final AtomicBoolean GLOBAL = new AtomicBoolean(false);
    private static final Set<WeakReference<MemorySafeWindowTinyLFUMap<?, ?>>> ALL = new CopyOnWriteArraySet();
    private final int maxFreeMemory;
    private final Cache<K, V> cache;

    public MemorySafeWindowTinyLFUMap(int maxFreeMemory, int initialSize) {
        this(maxFreeMemory, initialSize, Long.MAX_VALUE, Constants.LRU_MAP_MAXSIZE);
    }

    public MemorySafeWindowTinyLFUMap(int maxFreeMemory, int initialSize, long expireAfterWrite, long maximumSize) {
        this.maxFreeMemory = maxFreeMemory;
        this.cache = Caffeine.newBuilder().expireAfterWrite(expireAfterWrite, TimeUnit.MILLISECONDS).maximumSize(maximumSize).initialCapacity(initialSize).build();
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public V put(K key, V value) {
        MemorySafeWindowTinyLFUMap.checkAndScheduleRefresh(this);
        Object previous = this.cache.getIfPresent(key);
        this.cache.put(key, value);
        return (V)previous;
    }

    @Override
    public V remove(Object key) {
        Object previous = this.cache.getIfPresent(key);
        this.cache.invalidate(key);
        this.cache.cleanUp();
        return (V)previous;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.asMap().entrySet();
    }

    public void cleanUp() {
        while (this.isFull()) {
            this.invalidate();
        }
    }

    public void invalidate() {
        this.cache.policy().eviction().ifPresent(eviction -> {
            @NonNull @NonNull Map coldest = eviction.coldest(1);
            if (coldest.size() == 0) {
                return;
            }
            Optional.ofNullable(coldest.entrySet().iterator().next()).ifPresent(entry -> this.cache.invalidate(entry.getKey()));
        });
    }

    public boolean isFull() {
        return this.cache.estimatedSize() > 0L && MemoryLimitCalculator.maxAvailable() < (long)this.maxFreeMemory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemorySafeWindowTinyLFUMap)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemorySafeWindowTinyLFUMap that = (MemorySafeWindowTinyLFUMap)o;
        return this.maxFreeMemory == that.maxFreeMemory && Objects.equals(this.cache, that.cache);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxFreeMemory, this.cache);
    }

    private static void checkAndScheduleRefresh(MemorySafeWindowTinyLFUMap<?, ?> map) {
        ALL.add(new WeakReference(map));
        if (!GLOBAL.get()) {
            MemorySafeWindowTinyLFUMap.refresh();
            if (GLOBAL.compareAndSet(false, true)) {
                ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create("Shenyu-Memory-Safe-Lru-Map", false));
                scheduledExecutorService.scheduleWithFixedDelay(MemorySafeWindowTinyLFUMap::refresh, 50L, 50L, TimeUnit.MILLISECONDS);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    GLOBAL.set(false);
                    scheduledExecutorService.shutdown();
                }));
            }
        }
    }

    private static void refresh() {
        for (WeakReference<MemorySafeWindowTinyLFUMap<?, ?>> weakReference : ALL) {
            MemorySafeWindowTinyLFUMap cacheMap = (MemorySafeWindowTinyLFUMap)weakReference.get();
            if (cacheMap != null) continue;
            ALL.remove(weakReference);
        }
        boolean anyFull = ALL.stream().map(Reference::get).filter(Objects::nonNull).anyMatch(MemorySafeWindowTinyLFUMap::isFull);
        while (anyFull) {
            ALL.stream().map(Reference::get).filter(Objects::nonNull).forEach(MemorySafeWindowTinyLFUMap::invalidate);
            anyFull = ALL.stream().map(Reference::get).filter(Objects::nonNull).anyMatch(MemorySafeWindowTinyLFUMap::isFull);
        }
    }
}

